/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.management.statuses;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.management.api.AdministrativeStatusManager;
import org.nuxeo.ecm.core.management.api.GlobalAdministrativeStatusManager;
import org.nuxeo.ecm.core.management.statuses.AdministrableServiceDescriptor;
import org.nuxeo.ecm.core.management.statuses.AdministrativeStatusManagerImpl;
import org.nuxeo.ecm.core.management.statuses.NuxeoInstanceIdentifierHelper;
import org.nuxeo.ecm.core.management.storage.AdministrativeStatusPersister;
import org.nuxeo.ecm.core.management.storage.DocumentModelStatusPersister;

public class GlobalAdministrativeStatusManagerImpl
implements GlobalAdministrativeStatusManager {
    protected final AdministrativeStatusPersister persister = new DocumentModelStatusPersister();
    protected final Map<String, AdministrativeStatusManager> managers = new HashMap<String, AdministrativeStatusManager>();
    protected final List<AdministrableServiceDescriptor> descriptors = new ArrayList<AdministrableServiceDescriptor>();
    protected final Map<String, AdministrableServiceDescriptor> descriptorsByServiceId = new HashMap<String, AdministrableServiceDescriptor>();

    @Override
    public String getLocalNuxeoInstanceIdentifier() {
        return NuxeoInstanceIdentifierHelper.getServerInstanceName();
    }

    @Override
    public AdministrativeStatusManager getStatusManager(String instanceIdentifier) {
        if (!this.managers.containsKey(instanceIdentifier)) {
            this.managers.put(instanceIdentifier, new AdministrativeStatusManagerImpl(this, this.persister, instanceIdentifier));
        }
        return this.managers.get(instanceIdentifier);
    }

    @Override
    public List<String> listInstanceIds() {
        return this.persister.getAllInstanceIds();
    }

    @Override
    public void setStatus(String serviceIdentifier, String state, String message, String login) {
        for (String instanceIdentifier : this.listInstanceIds()) {
            this.getStatusManager(instanceIdentifier).setStatus(serviceIdentifier, state, message, login);
        }
    }

    @Override
    public void registerService(AdministrableServiceDescriptor desc) {
        this.descriptors.add(desc);
        this.descriptorsByServiceId.put(desc.getId(), desc);
    }

    @Override
    public List<AdministrableServiceDescriptor> listRegistredServices() {
        return this.descriptors;
    }

    @Override
    public AdministrableServiceDescriptor getServiceDescriptor(String serviceIdentifier) {
        return this.descriptorsByServiceId.get(serviceIdentifier);
    }
}

