/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.relations.web;

import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.relations.api.Literal;
import org.nuxeo.ecm.platform.relations.api.Node;
import org.nuxeo.ecm.platform.relations.api.NodeType;
import org.nuxeo.ecm.platform.relations.api.QNameResource;
import org.nuxeo.ecm.platform.relations.api.Resource;
import org.nuxeo.ecm.platform.relations.web.NodeInfo;
import org.nuxeo.ecm.platform.ui.web.tag.fn.DocumentModelFunctions;

public class NodeInfoImpl
implements NodeInfo {
    private static final long serialVersionUID = -5807130430819964154L;
    protected final Node node;
    protected DocumentModel documentModel;
    protected boolean visible = false;

    public NodeInfoImpl(Node node) {
        this.node = node;
    }

    public NodeInfoImpl(Node node, DocumentModel documentModel) {
        this.node = node;
        this.documentModel = documentModel;
    }

    public NodeInfoImpl(Node node, DocumentModel documentModel, boolean visible) {
        this.node = node;
        this.documentModel = documentModel;
        this.visible = visible;
    }

    public NodeType getNodeType() {
        return this.node.getNodeType();
    }

    public boolean isBlank() {
        return this.node.isBlank();
    }

    public boolean isLiteral() {
        return this.node.isLiteral();
    }

    public boolean isQNameResource() {
        return this.node.isQNameResource();
    }

    public boolean isResource() {
        return this.node.isResource();
    }

    public int compareTo(Node o) {
        return this.node.compareTo((Object)o);
    }

    @Override
    public String getAction() {
        if (this.visible && this.documentModel != null) {
            String docId = this.documentModel.getId();
            String actionValue = String.format("#{navigationContext.navigateToId('%s')}", docId);
            return actionValue;
        }
        return null;
    }

    @Override
    public DocumentModel getDocumentModel() {
        return this.documentModel;
    }

    @Override
    public String getHref() {
        if (this.documentModel == null && this.isResource()) {
            return ((Resource)this.node).getUri();
        }
        return null;
    }

    @Override
    public String getIcon() {
        return DocumentModelFunctions.iconPath((DocumentModel)this.documentModel);
    }

    @Override
    public String getTitle() {
        String title = null;
        if (this.node.isLiteral()) {
            title = ((Literal)this.node).getValue();
        } else if (this.node.isQNameResource()) {
            String resourceTitle = null;
            QNameResource resource = (QNameResource)this.node;
            if (this.documentModel != null) {
                String documentTitle;
                try {
                    documentTitle = (String)this.documentModel.getProperty("dublincore", "title");
                }
                catch (ClientException e) {
                    throw new ClientRuntimeException((Throwable)e);
                }
                if (documentTitle != null && documentTitle.length() > 0) {
                    resourceTitle = documentTitle;
                }
            }
            title = resourceTitle == null ? resource.getUri() : resourceTitle;
        } else if (this.node.isResource()) {
            title = ((Resource)this.node).getUri();
        }
        return title;
    }

    @Override
    public boolean isLink() {
        return this.getHref() != null;
    }

    @Override
    public boolean isDocument() {
        return this.documentModel != null;
    }

    @Override
    public boolean isDocumentVisible() {
        return this.documentModel != null && this.visible;
    }

    @Override
    public boolean isText() {
        return !this.isDocumentVisible() && !this.isLink();
    }
}

