/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.dublincore.listener;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.dublincore.NXDublinCore;
import org.nuxeo.ecm.platform.dublincore.service.DublinCoreStorageService;

public class DublinCoreListener
implements EventListener {
    private static final Log log = LogFactory.getLog(DublinCoreListener.class);
    public static final String DISABLE_DUBLINCORE_LISTENER = "disableDublinCoreListener";

    public void handleEvent(Event event) throws ClientException {
        if (!(event.getContext() instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext docCtx = (DocumentEventContext)event.getContext();
        String eventId = event.getName();
        if (!(eventId.equals("documentModified") || eventId.equals("documentCreated") || eventId.equals("beforeDocumentModification") || eventId.equals("lifecycle_transition_event") || eventId.equals("documentPublished"))) {
            return;
        }
        DublinCoreStorageService service = NXDublinCore.getDublinCoreStorageService();
        if (service == null) {
            log.error((Object)"DublinCoreStorage service not found ... !");
            return;
        }
        Boolean block = (Boolean)event.getContext().getProperty(DISABLE_DUBLINCORE_LISTENER);
        if (block != null && block.booleanValue()) {
            return;
        }
        DocumentModel doc = docCtx.getSourceDocument();
        if (doc.isVersion()) {
            log.debug((Object)"No DublinCore update on versions except for the issued date");
            return;
        }
        if (doc.hasFacet("SystemDocument")) {
            return;
        }
        Date eventDate = new Date(event.getTime());
        Calendar cEventDate = Calendar.getInstance();
        cEventDate.setTime(eventDate);
        if (doc.isProxy() && eventId.equals("documentPublished")) {
            CoreSession session = event.getContext().getCoreSession();
            UnrestrictedPropertySetter setter = new UnrestrictedPropertySetter(session, doc.getRef(), "dc:issued", cEventDate);
            setter.runUnrestricted();
        }
        if (eventId.equals("beforeDocumentModification") || eventId.equals("lifecycle_transition_event") && !doc.isImmutable()) {
            service.setModificationDate(doc, cEventDate, event);
            service.addContributor(doc, event);
        } else if (eventId.equals("documentCreated")) {
            service.setCreationDate(doc, cEventDate, event);
            service.setModificationDate(doc, cEventDate, event);
            service.addContributor(doc, event);
        }
    }

    protected class UnrestrictedPropertySetter
    extends UnrestrictedSessionRunner {
        DocumentRef docRef;
        String xpath;
        Serializable value;

        protected UnrestrictedPropertySetter(CoreSession session, DocumentRef docRef, String xpath, Serializable value) {
            super(session);
            this.docRef = docRef;
            this.xpath = xpath;
            this.value = value;
        }

        public void run() throws ClientException {
            DocumentModel doc = this.session.getSourceDocument(this.docRef);
            if (doc != null) {
                doc.setPropertyValue(this.xpath, this.value);
                this.session.saveDocument(doc);
            }
        }
    }
}

