/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.atompub;

import java.math.BigInteger;
import java.util.GregorianCalendar;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomDocumentBase;

public class AtomFeed
extends AtomDocumentBase {
    public static final BigInteger DEFAULT_PAGE_SIZE = BigInteger.valueOf(100L);

    public AtomFeed() {
    }

    public AtomFeed(XMLStreamWriter writer) {
        this.setWriter(writer);
    }

    public void startFeed(boolean isRoot) throws XMLStreamException {
        this.getWriter().writeStartElement("http://www.w3.org/2005/Atom", "feed");
        if (isRoot) {
            this.writeNamespace("http://www.w3.org/2005/Atom");
            this.writeNamespace("http://docs.oasis-open.org/ns/cmis/core/200908/");
            this.writeNamespace("http://docs.oasis-open.org/ns/cmis/restatom/200908/");
            this.writeNamespace("http://www.w3.org/2007/app");
        }
    }

    public void startChildren() throws XMLStreamException {
        XMLStreamWriter writer = this.getWriter();
        writer.writeStartElement("http://docs.oasis-open.org/ns/cmis/restatom/200908/", "children");
    }

    public void endChildren() throws XMLStreamException {
        this.getWriter().writeEndElement();
    }

    public void endFeed() throws XMLStreamException {
        this.getWriter().writeEndElement();
    }

    public void writeFeedElements(String id, String author, String title, GregorianCalendar updated, String pathSegment, BigInteger numItems) throws XMLStreamException {
        this.writeAuthor(author);
        this.writeId(this.generateAtomId(id));
        this.writeTitle(title);
        this.writeUpdated(updated);
        this.writePathSegment(pathSegment);
        this.writeNumItems(numItems);
    }

    public void writeNumItems(BigInteger numItems) throws XMLStreamException {
        if (numItems == null) {
            return;
        }
        this.writeSimpleTag("http://docs.oasis-open.org/ns/cmis/restatom/200908/", "numItems", numItems.toString());
    }

    public void writePagingLinks(UrlBuilder pagingUrl, BigInteger maxItems, BigInteger skipCount, BigInteger numItems, Boolean hasMoreItems, BigInteger pageSize) throws XMLStreamException {
        BigInteger lastSkip;
        if (skipCount == null || skipCount.compareTo(BigInteger.ZERO) == -1) {
            skipCount = BigInteger.ZERO;
        }
        if (maxItems == null || maxItems.compareTo(BigInteger.ZERO) == -1) {
            maxItems = pageSize == null || pageSize.compareTo(BigInteger.ZERO) == -1 ? DEFAULT_PAGE_SIZE : pageSize;
        }
        if (skipCount.compareTo(BigInteger.ZERO) == 1) {
            UrlBuilder firstLink = new UrlBuilder(pagingUrl);
            firstLink.addParameter("skipCount", (Object)"0");
            firstLink.addParameter("maxItems", (Object)maxItems);
            this.writeFirstLink(firstLink.toString());
            UrlBuilder previousLink = new UrlBuilder(pagingUrl);
            previousLink.addParameter("skipCount", (Object)skipCount.subtract(maxItems).max(BigInteger.ZERO));
            previousLink.addParameter("maxItems", (Object)maxItems);
            this.writePreviousLink(previousLink.toString());
        }
        if (hasMoreItems != null && hasMoreItems.booleanValue()) {
            UrlBuilder nextLink = new UrlBuilder(pagingUrl);
            nextLink.addParameter("skipCount", (Object)skipCount.add(maxItems));
            nextLink.addParameter("maxItems", (Object)maxItems);
            this.writeNextLink(nextLink.toString());
        }
        if (numItems != null && numItems.compareTo(BigInteger.ZERO) == 1 && (lastSkip = numItems.subtract(maxItems).max(BigInteger.ZERO)).compareTo(BigInteger.ZERO) == 1) {
            UrlBuilder lastLink = new UrlBuilder(pagingUrl);
            lastLink.addParameter("skipCount", (Object)lastSkip);
            lastLink.addParameter("maxItems", (Object)maxItems);
            this.writeLastLink(lastLink.toString());
        }
    }
}

