/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.shared;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dispatcher
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String METHOD_GET = "GET";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_PUT = "PUT";
    public static final String METHOD_DELETE = "DELETE";
    private static final Log LOG = LogFactory.getLog((String)Dispatcher.class.getName());
    private final boolean caseSensitive;
    private Map<String, Method> methodMap = new HashMap<String, Method>();

    public Dispatcher() {
        this(true);
    }

    public Dispatcher(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public synchronized void addResource(String resource, String httpMethod, Class<?> clazz, String classmethod) throws NoSuchMethodException {
        Method m = clazz.getMethod(classmethod, CallContext.class, CmisService.class, String.class, HttpServletRequest.class, HttpServletResponse.class);
        this.methodMap.put(this.getKey(resource, httpMethod), m);
    }

    public boolean dispatch(String resource, String httpMethod, CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) {
        Method m = this.methodMap.get(this.getKey(resource, httpMethod));
        if (m == null) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(repositoryId + " / " + resource + ", " + httpMethod + " -> " + m.getName()));
        }
        try {
            m.invoke(null, context, service, repositoryId, request, response);
        }
        catch (IllegalAccessException e) {
            throw new CmisRuntimeException("Internal error!", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CmisBaseException) {
                throw (CmisBaseException)e.getCause();
            }
            throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
        }
        return true;
    }

    private String getKey(String resource, String httpMethod) {
        String s = resource + "/" + httpMethod;
        return this.caseSensitive ? s : s.toUpperCase();
    }
}

