/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.browser;

import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Map;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.browser.AbstractBrowserBindingService;
import org.apache.chemistry.opencmis.client.bindings.spi.browser.FormDataWriter;
import org.apache.chemistry.opencmis.client.bindings.spi.http.HttpUtils;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.spi.DiscoveryService;
import org.apache.chemistry.opencmis.commons.spi.Holder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoveryServiceImpl
extends AbstractBrowserBindingService
implements DiscoveryService {
    public DiscoveryServiceImpl(BindingSession session) {
        this.setSession(session);
    }

    public ObjectList query(String repositoryId, String statement, Boolean searchAllVersions, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        UrlBuilder url = this.getRepositoryUrl(repositoryId);
        final FormDataWriter formData = new FormDataWriter("query");
        formData.addParameter("q", statement);
        formData.addParameter("searchAllVersions", searchAllVersions);
        formData.addParameter("includeAllowableActions", includeAllowableActions);
        formData.addParameter("includeRelationships", includeRelationships);
        formData.addParameter("renditionFilter", renditionFilter);
        formData.addParameter("maxItems", maxItems);
        formData.addParameter("skipCount", skipCount);
        HttpUtils.Response resp = this.post(url, formData.getContentType(), new HttpUtils.Output(){

            public void write(OutputStream out) throws Exception {
                formData.write(out);
            }
        });
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        return JSONConverter.convertObjectList(json, (boolean)true);
    }

    public ObjectList getContentChanges(String repositoryId, Holder<String> changeLogToken, Boolean includeProperties, String filter, Boolean includePolicyIds, Boolean includeAcl, BigInteger maxItems, ExtensionsData extension) {
        Object token;
        UrlBuilder url = this.getRepositoryUrl(repositoryId, "contentChanges");
        url.addParameter("includeSubRelationshipTypes", changeLogToken == null ? null : (String)changeLogToken.getValue());
        url.addParameter("includeProperties", (Object)includeProperties);
        url.addParameter("filter", (Object)filter);
        url.addParameter("includePolicyIds", (Object)includePolicyIds);
        url.addParameter("includeACL", (Object)includeAcl);
        url.addParameter("maxItems", (Object)maxItems);
        HttpUtils.Response resp = this.read(url);
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        if (changeLogToken != null && json != null && (token = json.get("changeLogToken")) instanceof String) {
            changeLogToken.setValue((Object)((String)token));
        }
        return JSONConverter.convertObjectList(json, (boolean)false);
    }
}

