/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.browser;

import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.browser.AbstractBrowserBindingService;
import org.apache.chemistry.opencmis.client.bindings.spi.browser.FormDataWriter;
import org.apache.chemistry.opencmis.client.bindings.spi.http.HttpUtils;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.spi.PolicyService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyServiceImpl
extends AbstractBrowserBindingService
implements PolicyService {
    public PolicyServiceImpl(BindingSession session) {
        this.setSession(session);
    }

    public void applyPolicy(String repositoryId, String policyId, String objectId, ExtensionsData extension) {
        UrlBuilder url = this.getObjectUrl(repositoryId, objectId);
        final FormDataWriter formData = new FormDataWriter("applyPolicy");
        formData.addPoliciesParameters(Collections.singletonList(policyId));
        this.postAndConsume(url, formData.getContentType(), new HttpUtils.Output(){

            public void write(OutputStream out) throws Exception {
                formData.write(out);
            }
        });
    }

    public void removePolicy(String repositoryId, String policyId, String objectId, ExtensionsData extension) {
        UrlBuilder url = this.getObjectUrl(repositoryId, objectId);
        final FormDataWriter formData = new FormDataWriter("removePolicy");
        formData.addPoliciesParameters(Collections.singletonList(policyId));
        this.postAndConsume(url, formData.getContentType(), new HttpUtils.Output(){

            public void write(OutputStream out) throws Exception {
                formData.write(out);
            }
        });
    }

    public List<ObjectData> getAppliedPolicies(String repositoryId, String objectId, String filter, ExtensionsData extension) {
        UrlBuilder url = this.getObjectUrl(repositoryId, objectId, "policies");
        url.addParameter("filter", (Object)filter);
        HttpUtils.Response resp = this.read(url);
        List<Object> json = this.parseArray(resp.getStream(), resp.getCharset());
        return JSONConverter.convertObjects(json);
    }
}

