/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs.batch;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.nuxeo.ecm.automation.core.util.ComplexTypeJSONDecoder;
import org.nuxeo.ecm.automation.core.util.JSONBlobDecoder;
import org.nuxeo.ecm.automation.server.jaxrs.batch.Batch;
import org.nuxeo.ecm.automation.server.jaxrs.batch.BatchManager;
import org.nuxeo.ecm.automation.server.jaxrs.batch.JSONBatchBlobDecoder;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.runtime.model.DefaultComponent;

public class BatchManagerComponent
extends DefaultComponent
implements BatchManager {
    protected ConcurrentHashMap<String, Batch> batches = new ConcurrentHashMap();
    protected static final String DEFAULT_CONTEXT = "None";

    @Override
    public String initBatch(String batchId, String contextName) {
        Batch batch = this.initBatchInternal(batchId, contextName);
        return batch.id;
    }

    protected Batch initBatchInternal(String batchId, String contextName) {
        Batch newBatch;
        Batch existingBatch;
        if (batchId == null || batchId.isEmpty()) {
            batchId = "batchId-" + UUID.randomUUID().toString();
        }
        if (contextName == null || contextName.isEmpty()) {
            contextName = DEFAULT_CONTEXT;
        }
        if ((existingBatch = this.batches.putIfAbsent(batchId, newBatch = new Batch(batchId))) != null) {
            return existingBatch;
        }
        return newBatch;
    }

    @Override
    public void addStream(String batchId, String idx, InputStream is, String name, String mime) throws IOException {
        Batch batch = this.batches.get(batchId);
        if (batch == null) {
            batch = this.initBatchInternal(batchId, null);
        }
        batch.addStream(idx, is, name, mime);
    }

    @Override
    public List<Blob> getBlobs(String batchId) {
        Batch batch = this.batches.get(batchId);
        if (batch == null) {
            return null;
        }
        return batch.getBlobs();
    }

    @Override
    public Blob getBlob(String batchId, String fileId) {
        Batch batch = this.batches.get(batchId);
        if (batch == null) {
            return null;
        }
        return batch.getBlob(fileId);
    }

    @Override
    public void clean(String batchId) {
        Batch batch = this.batches.get(batchId);
        if (batch != null) {
            batch.clear();
            this.batches.remove(batchId);
        }
    }

    static {
        ComplexTypeJSONDecoder.registerBlobDecoder((JSONBlobDecoder)new JSONBatchBlobDecoder());
    }
}

