/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.blob;

import java.io.Serializable;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;

@Operation(id="Blob.SetFilename", category="Files", label="Set File Name", description="Modify the filename of a file stored in the input document. The file is found in the input document given its xpath specified through the 'xpath' parameter. Return back the input document.")
public class SetBlobFileName {
    public static final String ID = "Blob.SetFilename";
    @Context
    protected OperationContext ctx;
    @Context
    protected CoreSession session;
    @Param(name="name")
    protected String name;
    @Param(name="xpath", required=false, values={"file:content"})
    protected String xpath = "file:content";
    @Param(name="save", required=false, values={"true"})
    protected boolean save = true;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) throws Exception {
        Property p = doc.getProperty(this.xpath);
        Serializable o = p.getValue();
        if (o instanceof Blob) {
            Blob blob = (Blob)o;
            blob.setFilename(this.name);
            p.setValue((Object)blob);
        }
        if (this.save) {
            doc = this.session.saveDocument(doc);
        }
        return doc;
    }
}

