/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.sql.SQLDirectoryDescriptor;
import org.nuxeo.ecm.directory.sql.SQLDirectoryProxy;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class SQLDirectoryRegistry
extends ContributionFragmentRegistry<SQLDirectoryDescriptor> {
    private static final Log log = LogFactory.getLog(SQLDirectoryRegistry.class);
    protected Map<String, SQLDirectoryDescriptor> descriptors = new HashMap<String, SQLDirectoryDescriptor>();
    protected Map<String, Directory> directories = new HashMap<String, Directory>();

    public String getContributionId(SQLDirectoryDescriptor contrib) {
        return contrib.getName();
    }

    public void contributionUpdated(String id, SQLDirectoryDescriptor descriptor, SQLDirectoryDescriptor newOrigContrib) {
        String directoryName = descriptor.getName();
        if (descriptor.getRemove()) {
            log.info((Object)("Removing directory: " + directoryName));
            this.contributionRemoved(id, descriptor);
        } else {
            if (this.directories.containsKey(directoryName)) {
                log.info((Object)("Re-registered directory: " + directoryName));
            } else {
                log.info((Object)("Registered directory: " + directoryName));
            }
            this.descriptors.put(id, descriptor);
            this.directories.put(id, new SQLDirectoryProxy(descriptor));
        }
    }

    public void contributionRemoved(String id, SQLDirectoryDescriptor descriptor) {
        String descriptorName = descriptor.getName();
        log.info((Object)("Unregistered directory: " + descriptorName));
        this.descriptors.remove(id);
        Directory dir = this.directories.remove(id);
        if (dir != null) {
            try {
                dir.shutdown();
            }
            catch (DirectoryException e) {
                log.error((Object)String.format("Error while shutting down directory '%s'", id), (Throwable)e);
            }
        }
    }

    public SQLDirectoryDescriptor clone(SQLDirectoryDescriptor orig) {
        return orig.clone();
    }

    public void merge(SQLDirectoryDescriptor src, SQLDirectoryDescriptor dst) {
        boolean remove = src.getRemove();
        boolean wasRemoved = dst.getRemove();
        if (remove) {
            dst.setRemove(remove);
            return;
        }
        dst.merge(src, wasRemoved);
    }

    public Directory getDirectory(String name) {
        return this.directories.get(name);
    }

    public List<Directory> getDirectories() {
        ArrayList<Directory> res = new ArrayList<Directory>();
        res.addAll(this.directories.values());
        return res;
    }
}

