/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.directory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.ui.web.directory.DirectoryHelper;
import org.nuxeo.ecm.webapp.directory.DirectoryTreeDescriptor;
import org.nuxeo.ecm.webapp.directory.DirectoryTreeManager;
import org.nuxeo.ecm.webapp.directory.DirectoryTreeNode;
import org.nuxeo.ecm.webapp.directory.DirectoryTreeService;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;
import org.nuxeo.ecm.webapp.seam.NuxeoSeamHotReloader;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.service.TimestampedService;
import org.richfaces.component.UITree;
import org.richfaces.event.NodeExpandedEvent;

@Scope(value=ScopeType.CONVERSATION)
@Name(value="directoryTreeManager")
public class DirectoryTreeManagerBean
implements DirectoryTreeManager {
    private static final long serialVersionUID = -5250556791009032616L;
    private static final Log log = LogFactory.getLog(DirectoryTreeManagerBean.class);
    public static final String NODE_SELECTED_MARKER = DirectoryTreeManagerBean.class.getName() + "_NODE_SELECTED_MARKER";
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected NuxeoSeamHotReloader seamReload;
    @In(create=true)
    protected ResourcesAccessor resourcesAccessor;
    protected transient Map<String, DirectoryTreeNode> treeModels;
    protected Long treeModelsTimestamp;
    protected transient DirectoryTreeService directoryTreeService;
    protected String selectedTree;
    private transient List<DirectoryTreeNode> directoryTrees;

    @Override
    public boolean isInitialized() {
        return this.documentManager != null;
    }

    @Override
    public DirectoryTreeNode get(String treeName) {
        DirectoryTreeNode treeModel;
        if (this.seamReload.isDevModeSet() && this.seamReload.shouldResetCache((TimestampedService)this.getDirectoryTreeService(), this.treeModelsTimestamp)) {
            this.treeModels = null;
        }
        if (this.treeModels == null) {
            this.treeModels = new HashMap<String, DirectoryTreeNode>();
        }
        if ((treeModel = this.treeModels.get(treeName)) != null) {
            return treeModel;
        }
        DirectoryTreeDescriptor config = this.getDirectoryTreeService().getDirectoryTreeDescriptor(treeName);
        if (config == null) {
            log.error((Object)("no DirectoryTreeDescriptor registered as " + treeName));
            return null;
        }
        String[] directories = config.getDirectories();
        DirectoryService directoryService = DirectoryHelper.getDirectoryService();
        SchemaManager schemaManager = (SchemaManager)Framework.getLocalService(SchemaManager.class);
        try {
            boolean isFirst = true;
            for (String directoryName : directories) {
                Schema schema;
                Directory directory = directoryService.getDirectory(directoryName);
                if (directory == null) {
                    throw new DirectoryException(directoryName + " is not a registered directory");
                }
                if (!isFirst && !(schema = schemaManager.getSchema(directory.getSchema())).hasField("parent")) {
                    throw new DirectoryException(directoryName + "does not have the required field: " + "parent");
                }
                isFirst = false;
            }
        }
        catch (DirectoryException e) {
            throw new RuntimeException(e);
        }
        treeModel = new DirectoryTreeNode(0, config, config.getName(), config.getLabel(), "", null);
        this.treeModels.put(treeName, treeModel);
        return treeModel;
    }

    @Override
    public List<String> getDirectoryTreeNames() {
        return this.getDirectoryTreeService().getDirectoryTrees();
    }

    @Override
    public List<DirectoryTreeNode> getDirectoryTrees() {
        if (this.directoryTrees == null) {
            this.directoryTrees = new LinkedList<DirectoryTreeNode>();
            for (String treeName : this.getDirectoryTreeNames()) {
                this.directoryTrees.add(this.get(treeName));
            }
        }
        return this.directoryTrees;
    }

    @Override
    public String getSelectedTreeName() {
        List<String> names;
        if (this.selectedTree == null && !(names = this.getDirectoryTreeNames()).isEmpty()) {
            this.selectedTree = names.get(0);
        }
        return this.selectedTree;
    }

    @Override
    public void setSelectedTreeName(String treeName) {
        this.selectedTree = treeName;
    }

    @Override
    public DirectoryTreeNode getSelectedTree() {
        return this.get(this.getSelectedTreeName());
    }

    protected DirectoryTreeService getDirectoryTreeService() {
        if (this.directoryTreeService != null) {
            return this.directoryTreeService;
        }
        this.directoryTreeService = (DirectoryTreeService)((Object)Framework.getRuntime().getComponent(DirectoryTreeService.NAME));
        return this.directoryTreeService;
    }

    @Override
    public void changeExpandListener(NodeExpandedEvent event) {
        UITree treeComponent;
        Object value;
        UIComponent component = event.getComponent();
        if (component instanceof UITree && (value = (treeComponent = (UITree)component).getRowData()) instanceof DirectoryTreeNode) {
            DirectoryTreeNode treeNode = (DirectoryTreeNode)value;
            if (treeNode.isOpen()) {
                treeNode.setOpen(false);
            } else {
                treeNode.setOpen(true);
            }
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        requestMap.put(NODE_SELECTED_MARKER, Boolean.TRUE);
    }

    protected Boolean isNodeExpandEvent() {
        ExternalContext externalContext;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null && (externalContext = facesContext.getExternalContext()) != null) {
            return Boolean.TRUE.equals(externalContext.getRequestMap().get(NODE_SELECTED_MARKER));
        }
        return false;
    }

    @Override
    public Boolean adviseNodeOpened(UITree treeComponent) {
        if (!this.isNodeExpandEvent().booleanValue()) {
            try {
                DirectoryTreeNode treeNode;
                Object value = treeComponent.getRowData();
                if (value instanceof DirectoryTreeNode && (treeNode = (DirectoryTreeNode)value).isOpened()) {
                    return Boolean.TRUE;
                }
            }
            catch (ClientException e) {
                log.error((Object)e);
            }
        }
        return null;
    }

    @Override
    public String getLabelFor(String directoryTreeName, String fullPath) {
        return this.getLabelFor(directoryTreeName, fullPath, false);
    }

    @Override
    public String getLabelFor(String directoryTreeName, String fullPath, boolean includeDirectoryTreeLabel) {
        DirectoryTreeNode rootNode = this.get(directoryTreeName);
        ArrayList<String> labels = new ArrayList<String>();
        this.computeLabels(labels, rootNode, fullPath, includeDirectoryTreeLabel);
        List<String> translatedLabels = this.translateLabels(labels);
        return StringUtils.join(translatedLabels, (String)"/");
    }

    protected void computeLabels(List<String> labels, DirectoryTreeNode node, String fullPath, boolean includeDirectoryTreeLabel) {
        if (!node.getPath().isEmpty() || node.getPath().isEmpty() && includeDirectoryTreeLabel) {
            labels.add(node.getDescription());
        }
        if (fullPath.equals(node.getPath())) {
            return;
        }
        for (DirectoryTreeNode treeNode : node.getChildren()) {
            if (!fullPath.startsWith(treeNode.getPath())) continue;
            this.computeLabels(labels, treeNode, fullPath, includeDirectoryTreeLabel);
        }
    }

    protected List<String> translateLabels(List<String> labels) {
        ArrayList<String> translatedLabels = new ArrayList<String>(labels.size());
        for (String label : labels) {
            translatedLabels.add(this.resourcesAccessor.getMessages().get(label));
        }
        return translatedLabels;
    }

    public void resetCurrentTree() {
        if (this.treeModels != null && this.selectedTree != null) {
            this.treeModels.remove(this.selectedTree);
        }
    }
}

