/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.tree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.api.Sorter;
import org.nuxeo.ecm.core.api.quota.QuotaStats;
import org.nuxeo.ecm.core.api.quota.QuotaStatsNonFolderishCount;
import org.nuxeo.ecm.core.search.api.client.querymodel.QueryModel;
import org.nuxeo.ecm.platform.contentview.jsf.ContentView;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.webapp.tree.DocumentTreeNode;
import org.nuxeo.runtime.api.Framework;

public class DocumentTreeNodeImpl
implements DocumentTreeNode {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(DocumentTreeNodeImpl.class);
    protected final DocumentModel document;
    protected final String sessionId;
    protected final Filter filter;
    protected final Filter leafFilter;
    protected final Sorter sorter;
    protected final String pageProviderName;
    protected ContentView orderableContentView;
    @Deprecated
    protected final QueryModel queryModel;
    @Deprecated
    protected final QueryModel orderableQueryModel;
    protected Map<Object, DocumentTreeNodeImpl> children;

    @Deprecated
    public DocumentTreeNodeImpl(DocumentModel document, Filter filter, Filter leafFilter, Sorter sorter, QueryModel queryModel) {
        this(document.getSessionId(), document, filter, leafFilter, sorter, queryModel);
    }

    @Deprecated
    public DocumentTreeNodeImpl(DocumentModel document, Filter filter, Filter leafFilter, Sorter sorter, QueryModel queryModel, QueryModel orderableQueryModel) {
        this(document.getSessionId(), document, filter, leafFilter, sorter, queryModel, orderableQueryModel);
    }

    @Deprecated
    public DocumentTreeNodeImpl(String sessionId, DocumentModel document, Filter filter, Filter leafFilter, Sorter sorter, QueryModel queryModel) {
        this(sessionId, document, filter, leafFilter, sorter, queryModel, null);
    }

    @Deprecated
    public DocumentTreeNodeImpl(String sessionId, DocumentModel document, Filter filter, Filter leafFilter, Sorter sorter, QueryModel queryModel, QueryModel orderableQueryModel) {
        this.document = document;
        this.sessionId = sessionId;
        this.filter = filter;
        this.leafFilter = leafFilter;
        this.sorter = sorter;
        this.queryModel = queryModel;
        this.orderableQueryModel = orderableQueryModel;
        this.pageProviderName = null;
    }

    public DocumentTreeNodeImpl(String sessionId, DocumentModel document, Filter filter, Filter leafFilter, Sorter sorter, String pageProviderName) {
        this.document = document;
        this.sessionId = sessionId;
        this.filter = filter;
        this.leafFilter = leafFilter;
        this.sorter = sorter;
        this.queryModel = null;
        this.orderableQueryModel = null;
        this.pageProviderName = pageProviderName;
    }

    public DocumentTreeNodeImpl(DocumentModel document, Filter filter, Sorter sorter) {
        this(document.getSessionId(), document, filter, null, sorter, (String)null);
    }

    public DocumentTreeNodeImpl(String sessionId, DocumentModel document, Filter filter, Sorter sorter) {
        this(sessionId, document, filter, null, sorter, (String)null);
    }

    @Override
    public List<DocumentTreeNode> getChildren() {
        if (this.children == null) {
            this.fetchChildren();
        }
        ArrayList<DocumentTreeNode> childrenNodes = new ArrayList<DocumentTreeNode>();
        childrenNodes.addAll(this.children.values());
        return childrenNodes;
    }

    public DocumentModel getDocument() {
        return this.document;
    }

    @Override
    public String getId() {
        if (this.document != null) {
            return this.document.getId();
        }
        return null;
    }

    @Override
    public String getPath() {
        if (this.document != null) {
            return this.document.getPathAsString();
        }
        return null;
    }

    public void resetChildren() {
        this.children = null;
    }

    public void fetchChildren() {
        try {
            Object documents;
            this.children = new LinkedHashMap<Object, DocumentTreeNodeImpl>();
            if (this.leafFilter != null && this.leafFilter.accept(this.document)) {
                return;
            }
            CoreSession session = CoreInstance.getInstance().getSession(this.sessionId);
            boolean isOrderable = this.document.hasFacet("Orderable");
            if (this.queryModel == null && this.pageProviderName == null) {
                Sorter sorterToUse = isOrderable ? null : this.sorter;
                documents = session.getChildren(this.document.getRef(), null, "Read", this.filter, sorterToUse);
            } else if (this.queryModel != null) {
                documents = isOrderable && this.orderableQueryModel != null ? this.orderableQueryModel.getDocuments(session, new Object[]{this.getId()}) : this.queryModel.getDocuments(session, new Object[]{this.getId()});
                documents = this.filterAndSort((List<DocumentModel>)documents, !isOrderable);
            } else {
                try {
                    PageProviderService ppService = (PageProviderService)Framework.getService(PageProviderService.class);
                    ArrayList<SortInfo> sortInfos = null;
                    HashMap<String, Serializable> props = new HashMap<String, Serializable>();
                    props.put("coreSession", (Serializable)session);
                    if (isOrderable) {
                        sortInfos = new ArrayList<SortInfo>();
                        sortInfos.add(new SortInfo("ecm:pos", true));
                    }
                    PageProvider pp = ppService.getPageProvider(this.pageProviderName, sortInfos, null, null, props, new Object[]{this.getId()});
                    documents = pp.getCurrentPage();
                    documents = this.filterAndSort((List<DocumentModel>)documents, !isOrderable);
                }
                catch (Exception e) {
                    throw new ClientException((Throwable)e);
                }
            }
            for (DocumentModel child : documents) {
                String identifier = child.getId();
                DocumentTreeNodeImpl childNode = this.queryModel != null ? new DocumentTreeNodeImpl(session.getSessionId(), child, this.filter, this.leafFilter, this.sorter, this.queryModel, this.orderableQueryModel) : new DocumentTreeNodeImpl(session.getSessionId(), child, this.filter, this.leafFilter, this.sorter, this.pageProviderName);
                this.children.put(identifier, childNode);
            }
        }
        catch (ClientException e) {
            log.error((Object)e);
        }
    }

    protected List<DocumentModel> filterAndSort(List<DocumentModel> docs, boolean doSort) {
        ArrayList<DocumentModel> res = new ArrayList<DocumentModel>();
        if (docs != null) {
            if (this.filter == null) {
                res.addAll(docs);
            } else {
                for (DocumentModel doc : docs) {
                    if (!this.filter.accept(doc)) continue;
                    res.add(doc);
                }
            }
        }
        if (this.sorter != null && doSort) {
            Collections.sort(res, this.sorter);
        }
        return res;
    }

    @Override
    public QuotaStats getQuotaStats() {
        return this.document != null ? (QuotaStatsNonFolderishCount)this.document.getAdapter(QuotaStatsNonFolderishCount.class) : null;
    }
}

