/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.app;

import com.sun.jersey.api.NotFoundException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.webengine.WebException;

@Provider
public class WebEngineExceptionMapper
implements ExceptionMapper<Throwable> {
    protected static final Log log = LogFactory.getLog(WebEngineExceptionMapper.class);

    public Response toResponse(Throwable t) {
        if (t instanceof NotFoundException) {
            NotFoundException nfe = (NotFoundException)t;
            log.error((Object)("JAX-RS 404 Not Found: " + nfe.getNotFoundUri()));
        } else {
            log.error((Object)"Exception in JAX-RS processing", t);
        }
        return WebException.wrap(t).getResponse();
    }
}

