/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.scripting;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.runtime.api.Framework;

public final class ScriptFile {
    public static final String ROOT_PATH = ((WebEngine)Framework.getLocalService(WebEngine.class)).getRootDirectory().getAbsolutePath();
    File file;
    String ext = "";

    public ScriptFile(File file) throws IOException {
        String name = file.getName();
        int p = name.lastIndexOf(46);
        if (p > -1) {
            this.ext = name.substring(p + 1);
        }
        this.file = file.getCanonicalFile();
    }

    public boolean isTemplate() {
        return "ftl".equals(this.ext);
    }

    public File getFile() {
        return this.file;
    }

    public String getExtension() {
        return this.ext;
    }

    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    public String getRelativePath() {
        return this.file.getAbsolutePath().substring(ROOT_PATH.length());
    }

    public String getFileName() {
        return this.file.getName();
    }

    public String getURL() throws MalformedURLException {
        return this.file.toURI().toURL().toExternalForm();
    }

    public URL toURL() throws MalformedURLException {
        return this.file.toURI().toURL();
    }

    public URI toURI() {
        return this.file.toURI();
    }

    public String toString() {
        return this.file.toString();
    }

    public long lastModified() {
        return this.file.lastModified();
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }
}

