/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.annotations.loader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.annotations.loader.AnnotationLoader;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class BundleAnnotationsLoader
implements BundleListener {
    private static final Log log = LogFactory.getLog(BundleAnnotationsLoader.class);
    protected static final BundleAnnotationsLoader instance = new BundleAnnotationsLoader();
    protected final Map<String, AnnotationLoader> loaders = new HashMap<String, AnnotationLoader>();
    protected final Map<String, List<Entry>> pendings = new HashMap<String, List<Entry>>();

    public static BundleAnnotationsLoader getInstance() {
        return instance;
    }

    public synchronized void addLoader(String annotationType, AnnotationLoader loader) {
        this.loaders.put(annotationType, loader);
        List<Entry> entries = this.pendings.remove(annotationType);
        if (entries != null) {
            for (Entry entry : entries) {
                try {
                    loader.loadAnnotation(entry.bundle, annotationType, entry.className, entry.args);
                }
                catch (Exception e) {
                    log.error((Object)("Failed to load annotation: " + annotationType + "@" + entry.className), (Throwable)e);
                }
            }
        }
    }

    public void loadAnnotationsFromDeployedBundles(Bundle bundle) throws IOException {
        Bundle[] bundles;
        for (Bundle b : bundles = bundle.getBundleContext().getBundles()) {
            this.loadAnnotations(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAnnotations(Bundle bundle) throws IOException {
        URL url = bundle.getEntry("OSGI-INF/annotations");
        if (url != null) {
            InputStream in = url.openStream();
            try {
                log.info((Object)("Loading annotations from bundle: " + bundle.getSymbolicName()));
                for (String line : BundleAnnotationsLoader.readLines(in)) {
                    this.loadAnnotation(bundle, line);
                }
            }
            finally {
                in.close();
            }
        }
    }

    protected void loadAnnotation(Bundle bundle, String line) {
        String[] ar = BundleAnnotationsLoader.parse(line);
        if (ar.length < 2) {
            log.error((Object)("Invalid annotation entry key '" + line + "' in bundle '" + bundle.getLocation() + "'."));
            return;
        }
        String className = ar[0];
        String annoType = ar[1];
        if (ar.length > 2) {
            String[] tmp = new String[ar.length - 2];
            System.arraycopy(ar, 2, tmp, 0, tmp.length);
            ar = tmp;
        }
        this.loadAnnotation(bundle, annoType, className, ar);
    }

    public static String[] parse(String str) {
        ArrayList<String> list = new ArrayList<String>();
        char[] chars = str.toCharArray();
        boolean esc = false;
        StringBuilder buf = new StringBuilder();
        char c = '\u0000';
        block4: for (int i = 0; i < chars.length; ++i) {
            c = chars[i];
            switch (c) {
                case '\\': {
                    if (!esc) {
                        esc = true;
                        continue block4;
                    }
                    esc = false;
                    buf.append(c);
                    continue block4;
                }
                case '|': {
                    if (!esc) {
                        list.add(buf.toString());
                        buf.setLength(0);
                        continue block4;
                    }
                    buf.append(c);
                    esc = false;
                    continue block4;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        if (buf.length() > 0) {
            list.add(buf.toString());
        } else if (c == '|') {
            list.add("");
        }
        return list.toArray(new String[list.size()]);
    }

    protected synchronized void loadAnnotation(Bundle bundle, String annotationType, String className, String[] args) {
        AnnotationLoader loader = this.loaders.get(annotationType);
        if (loader != null) {
            try {
                loader.loadAnnotation(bundle, annotationType, className, args);
            }
            catch (Exception e) {
                log.error((Object)("Failed to load annotation: " + annotationType + "@" + className), (Throwable)e);
            }
        } else {
            List<Entry> entries = this.pendings.get(annotationType);
            if (entries == null) {
                entries = new ArrayList<Entry>();
                this.pendings.put(annotationType, entries);
            }
            entries.add(new Entry(bundle, className, args));
        }
    }

    public void bundleChanged(BundleEvent event) {
        try {
            switch (event.getType()) {
                case 32: {
                    this.loadAnnotations(event.getBundle());
                    break;
                }
            }
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    public static List<String> readLines(InputStream in) throws IOException {
        String line;
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        while ((line = reader.readLine()) != null) {
            lines.add(line);
        }
        return lines;
    }

    static class Entry {
        final Bundle bundle;
        final String className;
        final String[] args;

        Entry(Bundle bundle, String className, String[] args) {
            this.bundle = bundle;
            this.className = className;
            this.args = args;
        }
    }
}

