/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.htmlparser.jericho.Attribute;
import net.htmlparser.jericho.ParseText;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class URIAttributes {
    private static final String[] uriAttributeNames = new String[]{"action", "background", "cite", "href", "longdesc", "src", "usemap"};
    private static final String[] objectURIAttributeNames = new String[]{"classid", "codebase", "data"};

    URIAttributes() {
    }

    public static List<Attribute> getList(Segment segment) {
        Attribute attribute;
        if (segment == null || segment.getFirstStartTag() == null) {
            return Collections.emptyList();
        }
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        for (String string : uriAttributeNames) {
            for (StartTag charSequence : segment.getAllStartTags(string, null)) {
                attribute = charSequence.getAttributes().get(string);
                attribute.startTag = charSequence;
                arrayList.add(attribute);
            }
        }
        for (StartTag startTag : segment.getAllStartTags("object")) {
            for (String string : objectURIAttributeNames) {
                attribute = startTag.getAttributes().get(string);
                if (attribute == null) continue;
                attribute.startTag = startTag;
                arrayList.add(attribute);
            }
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public static List<Segment> getStyleURISegments(Segment segment) {
        if (segment == null || segment.length() == 0) {
            return Collections.emptyList();
        }
        if (segment.getFirstStartTag() == null) {
            int n = segment.getSource().getParseText().indexOf("url(", segment.getBegin(), segment.getEnd());
            if (n == -1) {
                return Collections.emptyList();
            }
            return URIAttributes.addURLSegmentsFromCSS(new ArrayList<Segment>(), new Segment(segment.getSource(), n, segment.getEnd()));
        }
        ArrayList<Segment> arrayList = new ArrayList<Segment>();
        for (StartTag startTag : segment.getAllStartTags("style", null)) {
            URIAttributes.addURLSegmentsFromCSS(arrayList, startTag.getAttributes().get("style").getValueSegment());
        }
        return arrayList;
    }

    private static List<Segment> addURLSegmentsFromCSS(List<Segment> list, Segment segment) {
        Source source = segment.getSource();
        ParseText parseText = source.getParseText();
        int n = segment.getEnd();
        int n2 = segment.getBegin();
        while ((n2 = parseText.indexOf("url(", n2, n)) != -1) {
            int n3;
            int n4;
            int n5;
            n2 += 4;
            while (n2 < n && Segment.isWhiteSpace(parseText.charAt(n2))) {
                ++n2;
            }
            if (n2 >= n || URIAttributes.isQuote(parseText.charAt(n2)) && ++n2 >= n || (n5 = parseText.indexOf(')', n4 = n2, n)) == -1) break;
            n2 = n5;
            while (Segment.isWhiteSpace(parseText.charAt(n2 - 1))) {
                --n2;
            }
            if (URIAttributes.isQuote(parseText.charAt(n2 - 1))) {
                // empty if block
            }
            if ((n3 = --n2) <= n4) break;
            list.add(new Segment(source, n4, n3));
            n2 = n5;
        }
        return list;
    }

    private static boolean isQuote(char c) {
        return c == '\"' || c == '\'';
    }
}

