/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.context;

import java.io.Serializable;
import java.security.Principal;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.util.RepositoryLocation;

@Name(value="userServicesContext")
@Scope(value=ScopeType.SESSION)
@Startup
public class UserServicesContext
implements Serializable {
    private static final long serialVersionUID = -4938620211123775744L;
    @In(create=true)
    private transient NavigationContext navigationContext;
    @In(required=false, create=true)
    private transient Principal currentUser;
    private transient RepositoryLocation repoLocation;
    private transient Boolean serverLocationRetrieved = false;

    private boolean isServerLocationSelected() {
        if (!this.serverLocationRetrieved.booleanValue()) {
            this.repoLocation = this.navigationContext.getCurrentServerLocation();
            this.serverLocationRetrieved = true;
        }
        return this.repoLocation != null;
    }

    @Observer(value={"locationSelectionChanged"}, create=false)
    @BypassInterceptors
    public void invalidate() {
        this.repoLocation = null;
        this.serverLocationRetrieved = false;
    }

    public Boolean getSearchEnabled() {
        return this.isServerLocationSelected();
    }

    public Boolean getDashboardEnabled() {
        return this.isServerLocationSelected();
    }

    public Boolean getUserManagerEnabled() {
        return this.isServerLocationSelected();
    }

    public boolean getVocabulariesEnabled() {
        if (this.currentUser == null) {
            return false;
        }
        return ((NuxeoPrincipal)this.currentUser).isAdministrator();
    }
}

