/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.note;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;

@Scope(value=ScopeType.CONVERSATION)
@Name(value="noteActions")
public class NoteActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Pattern PATTERN_TO_CHECK = Pattern.compile("(.*<img.*/files:files/.*/>.*)?");
    protected static final String PATTERN_TO_REPLACE = "((<img.*?)%s(/files:files/.*?/>))";
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true, required=false)
    protected transient NavigationContext navigationContext;

    public String translateImageLinks(String note) throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (!currentDocument.isProxy() && !currentDocument.isVersion()) {
            return note;
        }
        if (!this.hasImageLinksToTranslate(note)) {
            return note;
        }
        String docIdToReplace = null;
        if (currentDocument.isVersion()) {
            docIdToReplace = currentDocument.getSourceId();
        } else if (currentDocument.isProxy()) {
            docIdToReplace = new LiveDocumentRefFinder(currentDocument).getLiveDocumentRef();
        }
        return this.translateImageLinks(note, docIdToReplace, currentDocument.getId());
    }

    protected boolean hasImageLinksToTranslate(String note) {
        Matcher matcher = PATTERN_TO_CHECK.matcher(note);
        return matcher.matches();
    }

    protected String translateImageLinks(String note, String fromDocRef, String toDocRef) {
        String patternToReplace = String.format(PATTERN_TO_REPLACE, fromDocRef);
        Pattern pattern = Pattern.compile(patternToReplace);
        Matcher matcher = pattern.matcher(note);
        String replacement = "$2" + toDocRef + "$3";
        return matcher.replaceAll(replacement);
    }

    private static class LiveDocumentRefFinder
    extends UnrestrictedSessionRunner {
        private String liveDocumentRef;
        private final DocumentModel proxy;

        public LiveDocumentRefFinder(DocumentModel proxy) {
            super(proxy.getRepositoryName());
            this.proxy = proxy;
        }

        public void run() throws ClientException {
            this.liveDocumentRef = this.proxy.getRef().toString();
            if (this.proxy.getSourceId() != null) {
                this.liveDocumentRef = this.proxy.getSourceId();
                DocumentModel version = this.session.getDocument((DocumentRef)new IdRef(this.proxy.getSourceId()));
                if (version.getSourceId() != null) {
                    this.liveDocumentRef = version.getSourceId();
                }
            }
        }

        public String getLiveDocumentRef() throws ClientException {
            if (this.liveDocumentRef == null) {
                this.runUnrestricted();
            }
            return this.liveDocumentRef;
        }
    }
}

