/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.api.adapters;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.blobholder.DocumentBlobHolder;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.platform.picture.api.adapters.PictureResourceAdapter;

public class PictureBlobHolder
extends DocumentBlobHolder {
    public PictureBlobHolder(DocumentModel doc, String path) {
        super(doc, path);
    }

    public Blob getBlob() throws ClientException {
        Blob blob = super.getBlob();
        return blob != null ? blob : this.getBlob("Original");
    }

    public void setBlob(Blob blob) throws ClientException {
        DocumentModel parent;
        this.xPathFilename = null;
        super.setBlob(blob);
        ArrayList pictureTemplates = null;
        CoreSession session = this.doc.getCoreSession();
        if (session.exists(this.doc.getRef())) {
            parent = session.getParentDocument(this.doc.getRef());
        } else {
            Path parentPath = this.doc.getPath().removeLastSegments(1);
            parent = session.getDocument((DocumentRef)new PathRef(parentPath.toString()));
        }
        if (parent != null && "PictureBook".equals(parent.getType()) && (pictureTemplates = (ArrayList)parent.getPropertyValue("picturebook:picturetemplates")).isEmpty()) {
            pictureTemplates = null;
        }
        PictureResourceAdapter picture = (PictureResourceAdapter)this.doc.getAdapter(PictureResourceAdapter.class);
        String filename = blob == null ? null : blob.getFilename();
        String title = (String)((Object)this.doc.getPropertyValue("dc:title"));
        try {
            picture.createPicture(blob, filename, title, pictureTemplates);
        }
        catch (IOException e) {
            throw new ClientException(e.toString(), (Throwable)e);
        }
    }

    public List<Blob> getBlobs() throws ClientException {
        ArrayList<Blob> blobList = new ArrayList<Blob>();
        Collection views = this.doc.getProperty("picture:views").getChildren();
        for (Property property : views) {
            blobList.add((Blob)property.getValue("content"));
        }
        return blobList;
    }

    public List<Blob> getBlobs(String ... viewNames) throws ClientException {
        ArrayList<Blob> blobList = new ArrayList<Blob>();
        for (int i = 0; i < viewNames.length; ++i) {
            blobList.add(this.getBlob(viewNames[i]));
        }
        return blobList;
    }

    public Blob getBlob(String title) throws ClientException {
        PictureResourceAdapter picture = (PictureResourceAdapter)this.doc.getAdapter(PictureResourceAdapter.class);
        return picture.getPictureFromTitle(title);
    }

    public String getHash() throws ClientException {
        String h;
        Blob blob = this.getBlob();
        if (blob != null && (h = blob.getDigest()) != null) {
            return h;
        }
        return this.doc.getId() + this.xPath + this.getModificationDate().toString();
    }
}

