/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.convert.service;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.convert.cache.GCTask;
import org.nuxeo.ecm.core.convert.service.ConversionServiceImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;

public class CacheCGTaskActivator
implements BundleActivator,
FrameworkListener {
    private static final Log log = LogFactory.getLog(CacheCGTaskActivator.class);
    private static final int defaultGCIntervalInMins = 10;
    protected static Thread gcThread;

    public void start(BundleContext context) throws Exception {
        context.addFrameworkListener((FrameworkListener)this);
    }

    public void stop(BundleContext context) throws Exception {
        this.endGC();
        context.removeFrameworkListener((FrameworkListener)this);
    }

    public void frameworkEvent(FrameworkEvent event) {
        if (event.getType() == 1) {
            long interval = ConversionServiceImpl.getGCIntervalInMinutes();
            if (interval <= 0L) {
                interval = 10L;
            }
            GCTask.setGCIntervalInMinutes(interval);
            this.startGC();
        }
    }

    public void startGC() {
        if (!GCTask.GCEnabled) {
            GCTask.GCEnabled = true;
            log.debug((Object)"CasheCGTaskActivator activated starting GC thread");
            gcThread = new Thread((Runnable)new GCTask(), "Nuxeo-Convert-GC");
            gcThread.setDaemon(true);
            gcThread.start();
            log.debug((Object)"GC Thread started");
        } else {
            log.debug((Object)"GC Thread is already started");
        }
    }

    public void endGC() {
        if (GCTask.GCEnabled) {
            GCTask.GCEnabled = false;
            log.debug((Object)"Stoping GC Thread");
            gcThread.interrupt();
        } else {
            log.debug((Object)"GC Thread is already stoped");
        }
    }
}

