/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.io;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ObjectNode;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.CompositeType;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.runtime.api.Framework;

public class JsonEncodeDecodeUtils {
    public static void encodeBlob(DocumentModel doc, String propVariableFacet, String variableName, Blob blob, JsonGenerator jg, ServletRequest request) throws JsonGenerationException, IOException {
        if (blob == null) {
            jg.writeNull();
            return;
        }
        jg.writeStartObject();
        String filename = blob.getFilename();
        if (filename == null) {
            jg.writeNullField("name");
        } else {
            jg.writeStringField("name", filename);
        }
        String v = blob.getMimeType();
        if (v == null) {
            jg.writeNullField("mime-type");
        } else {
            jg.writeStringField("mime-type", v);
        }
        v = blob.getEncoding();
        if (v == null) {
            jg.writeNullField("encoding");
        } else {
            jg.writeStringField("encoding", v);
        }
        v = blob.getDigest();
        if (v == null) {
            jg.writeNullField("digest");
        } else {
            jg.writeStringField("digest", v);
        }
        jg.writeStringField("length", Long.toString(blob.getLength()));
        String facet = null;
        try {
            facet = (String)((Object)doc.getPropertyValue(propVariableFacet));
        }
        catch (PropertyNotFoundException e) {
            facet = propVariableFacet;
        }
        if (StringUtils.isBlank((String)facet)) {
            return;
        }
        CompositeType type = ((SchemaManager)Framework.getLocalService(SchemaManager.class)).getFacet(facet);
        DownloadService downloadService = (DownloadService)Framework.getService(DownloadService.class);
        String xpath = type.getField(variableName).getName().getPrefixedName();
        String blobUrl = VirtualHostHelper.getBaseURL((ServletRequest)request) + downloadService.getDownloadUrl(doc, xpath, filename);
        jg.writeStringField("url", blobUrl);
        jg.writeEndObject();
    }

    @Deprecated
    public static Map<String, Serializable> decodeVariables(JsonNode jsnode, Map<String, Serializable> originalVariables, CoreSession session) throws ClassNotFoundException, IOException {
        HashMap<String, Serializable> variables = new HashMap<String, Serializable>();
        Iterator it = jsnode.getFields();
        while (it.hasNext()) {
            Map.Entry variable = (Map.Entry)it.next();
            String key = (String)variable.getKey();
            JsonNode value = (JsonNode)variable.getValue();
            if (value.isNumber()) {
                variables.put(key, (Serializable)((Object)value.getNumberValue().toString()));
                continue;
            }
            if (value.isObject()) {
                if (!value.has("upload-batch")) continue;
                ObjectNode upload = (ObjectNode)value;
                upload.put("type", "blob");
                variables.put(key, (Serializable)((Object)upload.toString()));
                continue;
            }
            variables.put(key, (Serializable)((Object)value.getTextValue()));
        }
        return variables;
    }

    public static void encodeVariableEntry(DocumentModel doc, String propVariableFacet, Map.Entry<String, Serializable> e, JsonGenerator jg, HttpServletRequest request) throws JsonGenerationException, IOException {
        if (e.getValue() instanceof Blob) {
            jg.writeFieldName(e.getKey());
            JsonEncodeDecodeUtils.encodeBlob(doc, propVariableFacet, e.getKey(), (Blob)e.getValue(), jg, (ServletRequest)request);
        } else {
            jg.writeObjectField(e.getKey(), (Object)e.getValue());
        }
    }
}

