/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.collections.core.adapter;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;

public class Collection {
    private static final Log log = LogFactory.getLog(Collection.class);
    protected DocumentModel document;

    public Collection(DocumentModel doc) {
        this.document = doc;
    }

    public List<String> getCollectedDocumentIds() {
        List collected = (List)((Object)this.document.getPropertyValue("collection:documentIds"));
        return collected;
    }

    public void addDocument(String documentId) {
        List<String> documentIds = this.getCollectedDocumentIds();
        if (!documentIds.contains(documentId)) {
            documentIds.add(documentId);
        }
        this.setDocumentIds(documentIds);
    }

    public void removeDocument(String documentId) {
        List<String> documentIds = this.getCollectedDocumentIds();
        if (!documentIds.remove(documentId)) {
            log.warn((Object)String.format("Element '%s' is not present in the specified collection.", documentId));
        }
        this.setDocumentIds(documentIds);
    }

    public void setDocumentIds(List<String> documentIds) {
        this.document.setPropertyValue("collection:documentIds", (Serializable)((Object)documentIds));
    }

    public DocumentModel getDocument() {
        return this.document;
    }
}

