/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema.types.constraints;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.schema.types.constraints.AbstractConstraint;
import org.nuxeo.ecm.core.schema.types.constraints.Constraint;
import org.nuxeo.ecm.core.schema.types.constraints.ConstraintUtils;

public class LengthConstraint
extends AbstractConstraint {
    private static final long serialVersionUID = 3630463971175189087L;
    private static final String NAME = "LengthConstraint";
    private static final String PNAME_MIN_LENGTH = "Minimum";
    private static final String PNAME_MAX_LENGTH = "Maximum";
    private final Long min;
    private final Long max;

    public LengthConstraint(Object min, Object max) {
        this.min = ConstraintUtils.objectToPostiveLong(min);
        this.max = ConstraintUtils.objectToPostiveLong(max);
    }

    @Override
    public boolean validate(Object object) {
        if (object == null) {
            return true;
        }
        int len = object.toString().length();
        if (this.min != null && (long)len < this.min) {
            return false;
        }
        return this.max == null || (long)len <= this.max;
    }

    @Override
    public Constraint.Description getDescription() {
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        if (this.min != null) {
            params.put(PNAME_MIN_LENGTH, this.min);
        }
        if (this.max != null) {
            params.put(PNAME_MAX_LENGTH, this.max);
        }
        return new Constraint.Description(NAME, params);
    }

    public Long getMin() {
        return this.min;
    }

    public Long getMax() {
        return this.max;
    }

    @Override
    public String getErrorMessage(Object invalidValue, Locale locale) {
        String subKey;
        Object[] params;
        if (this.min != null && this.max != null) {
            params = new Object[]{this.min, this.max};
            subKey = "minmax";
        } else if (this.min != null) {
            params = new Object[]{this.min};
            subKey = "min";
        } else {
            params = new Object[]{this.max};
            subKey = "max";
        }
        ArrayList<String> pathTokens = new ArrayList<String>();
        pathTokens.add("label.schema.constraint.violation");
        pathTokens.add(NAME);
        pathTokens.add(subKey);
        String key = StringUtils.join(pathTokens, (char)'.');
        Locale computedLocale = locale != null ? locale : Constraint.MESSAGES_DEFAULT_LANG;
        String message = LengthConstraint.getMessageString("messages", key, params, computedLocale);
        if (message != null && !message.trim().isEmpty() && !key.equals(message)) {
            return message;
        }
        return super.getErrorMessage(invalidValue, computedLocale);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.max == null ? 0 : this.max.hashCode());
        result = 31 * result + (this.min == null ? 0 : this.min.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LengthConstraint other = (LengthConstraint)obj;
        if (this.max == null ? other.max != null : !this.max.equals(other.max)) {
            return false;
        }
        return !(this.min == null ? other.min != null : !this.min.equals(other.min));
    }
}

