/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.blob.AbstractBlobProvider;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.ecm.core.blob.SimpleManagedBlob;
import org.nuxeo.ecm.core.model.Document;

public class FilesystemBlobProvider
extends AbstractBlobProvider {
    public static final String ROOT_PROP = "root";
    protected String root;

    @Override
    public void initialize(String blobProviderId, Map<String, String> properties) throws IOException {
        super.initialize(blobProviderId, properties);
        this.root = properties.get(ROOT_PROP);
        if (StringUtils.isBlank((String)this.root)) {
            throw new NuxeoException("Missing property 'root' for " + this.getClass().getSimpleName() + ": " + blobProviderId);
        }
        if ("/".equals(this.root)) {
            this.root = "";
        } else if (!this.root.endsWith("/")) {
            this.root = this.root + "/";
        }
    }

    @Override
    public void close() {
    }

    @Override
    public Blob readBlob(BlobManager.BlobInfo blobInfo) throws IOException {
        return new SimpleManagedBlob(blobInfo);
    }

    @Override
    public InputStream getStream(ManagedBlob blob) throws IOException {
        String key = blob.getKey();
        int colon = key.indexOf(58);
        if (colon >= 0 && key.substring(0, colon).equals(this.blobProviderId)) {
            key = key.substring(colon + 1);
        }
        if (key.contains("..")) {
            throw new FileNotFoundException("Illegal path: " + key);
        }
        return Files.newInputStream(Paths.get(this.root + key, new String[0]), new OpenOption[0]);
    }

    @Override
    public boolean supportsUserUpdate() {
        return this.supportsUserUpdateDefaultFalse();
    }

    @Override
    public String writeBlob(Blob blob, Document doc) throws IOException {
        throw new UnsupportedOperationException("Writing a blob is not supported");
    }

    public ManagedBlob createBlob(BlobManager.BlobInfo blobInfo) throws IOException {
        String filePath = blobInfo.key;
        if (filePath.contains("..")) {
            throw new FileNotFoundException("Illegal path: " + filePath);
        }
        if (!filePath.startsWith(this.root)) {
            throw new FileNotFoundException("Path is not under configured root: " + filePath);
        }
        Path path = Paths.get(filePath, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException(filePath);
        }
        while (Files.isSymbolicLink(path)) {
            if (Files.exists(path = Files.readSymbolicLink(path), new LinkOption[0])) continue;
            throw new FileNotFoundException(filePath);
        }
        String relativePath = filePath.substring(this.root.length());
        long length = Files.size(path);
        blobInfo = new BlobManager.BlobInfo(blobInfo);
        blobInfo.key = this.blobProviderId + ":" + relativePath;
        blobInfo.length = length;
        if (blobInfo.filename == null) {
            blobInfo.filename = Paths.get(filePath, new String[0]).getFileName().toString();
        }
        if (blobInfo.digest == null) {
            try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
                blobInfo.digest = DigestUtils.md5Hex((InputStream)in);
            }
        }
        return new SimpleManagedBlob(blobInfo);
    }
}

