/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.versioning;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.VersionModel;
import org.nuxeo.ecm.core.api.impl.VersionModelImpl;
import org.nuxeo.ecm.platform.query.api.PageSelection;
import org.nuxeo.ecm.platform.query.api.PageSelections;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.UserAction;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListsManager;
import org.nuxeo.ecm.webapp.helpers.EventManager;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;
import org.nuxeo.ecm.webapp.versioning.DocumentVersioning;
import org.nuxeo.ecm.webapp.versioning.VersionedActions;

@Name(value="versionedActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class VersionedActionsBean
implements VersionedActions,
Serializable {
    private static final long serialVersionUID = 4472648747609642493L;
    private static final Log log = LogFactory.getLog(VersionedActionsBean.class);
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true, required=false)
    protected transient DocumentsListsManager documentsListsManager;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true, required=false)
    protected transient FacesMessages facesMessages;
    @In(create=true, required=false)
    protected transient ResourcesAccessor resourcesAccessor;
    @In
    protected transient Context sessionContext;
    @In(create=true)
    protected transient DocumentVersioning documentVersioning;
    protected transient PageSelections<VersionModel> versionModelList;
    protected String selectedVersionId;
    protected String checkedOut;

    @Override
    @Create
    public void initialize() {
    }

    @Override
    @Observer(value={"documentSelectionChanged", "documentChanged", "documentSubmitedForPublication", "documentPublished"}, create=false)
    @BypassInterceptors
    public void resetVersions() {
        this.versionModelList = null;
    }

    @Override
    @Factory(value="versionList", scope=ScopeType.EVENT)
    public PageSelections<VersionModel> getVersionList() {
        if (this.versionModelList == null || this.versionModelList.getEntries() == null || this.versionModelList.getEntries().isEmpty()) {
            this.retrieveVersions();
        }
        return this.versionModelList;
    }

    @Override
    public void retrieveVersions() {
        DocumentModel doc;
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (currentDocument.isProxy()) {
            DocumentRef ref = currentDocument.getRef();
            DocumentModel version = this.documentManager.getSourceDocument(ref);
            doc = this.documentManager.getSourceDocument(version.getRef());
        } else {
            doc = currentDocument;
        }
        ArrayList<PageSelection> versionModelSelections = new ArrayList<PageSelection>();
        for (VersionModel versionModel : this.documentVersioning.getItemVersioningHistory(doc)) {
            versionModelSelections.add(new PageSelection((Object)versionModel, this.isVersionSelected(versionModel)));
        }
        this.versionModelList = new PageSelections(versionModelSelections);
    }

    protected boolean isVersionSelected(VersionModel versionModel) {
        DocumentModel version;
        DocumentModel currentDocument;
        List currentVersionSelection = this.documentsListsManager.getWorkingList("CURRENT_SELECTION_VERSIONS");
        if (currentVersionSelection != null && (currentDocument = this.navigationContext.getCurrentDocument()) != null && (version = this.documentManager.getDocumentWithVersion(currentDocument.getRef(), versionModel)) != null) {
            return currentVersionSelection.contains(version);
        }
        return false;
    }

    @Override
    public String restoreToVersion(VersionModel selectedVersion) {
        DocumentModel restoredDocument = this.documentManager.restoreToVersion(this.navigationContext.getCurrentDocument().getRef(), (DocumentRef)new IdRef(selectedVersion.getId()), true, true);
        this.documentManager.save();
        EventManager.raiseEventsOnDocumentChange((DocumentModel)restoredDocument);
        return this.navigationContext.navigateToDocument(restoredDocument, "after-edit");
    }

    @Override
    public String restoreToVersion() {
        if (this.getSelectedVersionId() != null) {
            VersionModelImpl selectedVersion = new VersionModelImpl();
            selectedVersion.setId(this.getSelectedVersionId());
            return this.restoreToVersion((VersionModel)selectedVersion);
        }
        return null;
    }

    @Override
    public String viewArchivedVersion(VersionModel selectedVersion) {
        return this.navigationContext.navigateToDocument(this.navigationContext.getCurrentDocument(), selectedVersion);
    }

    @Override
    public String viewArchivedVersion() {
        if (this.getSelectedVersionId() != null) {
            VersionModelImpl selectedVersion = new VersionModelImpl();
            selectedVersion.setId(this.getSelectedVersionId());
            return this.viewArchivedVersion((VersionModel)selectedVersion);
        }
        return null;
    }

    @Override
    public boolean getCanRestore() {
        return this.documentManager.hasPermission(this.navigationContext.getCurrentDocument().getRef(), "WriteVersion");
    }

    @Override
    public String getCheckedOut() {
        this.checkedOut = this.documentManager.isCheckedOut(this.navigationContext.getCurrentDocument().getRef()) ? "Checked-out" : "Checked-in";
        return this.checkedOut;
    }

    @Override
    public void setCheckedOut(String checkedOut) {
        this.checkedOut = checkedOut;
    }

    @Override
    public String checkOut() {
        this.documentManager.checkOut(this.navigationContext.getCurrentDocument().getRef());
        return null;
    }

    @Override
    public String checkIn() {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        this.documentManager.checkIn(currentDocument.getRef(), null, null);
        this.retrieveVersions();
        return this.navigationContext.getActionResult(currentDocument, UserAction.AFTER_EDIT);
    }

    @Override
    public DocumentModel getSourceDocument() {
        return this.getSourceDocument(this.navigationContext.getCurrentDocument());
    }

    @Override
    public DocumentModel getSourceDocument(DocumentModel document) {
        return this.documentManager.getSourceDocument(document.getRef());
    }

    @Override
    public boolean canRemoveArchivedVersion(VersionModel selectedVersion) {
        DocumentRef docRef = this.navigationContext.getCurrentDocument().getRef();
        DocumentModel docVersion = this.documentManager.getDocumentWithVersion(docRef, selectedVersion);
        if (docVersion == null) {
            log.warn((Object)("Unexpectedly couldn't find the version " + selectedVersion.getLabel()));
            return false;
        }
        return this.documentManager.canRemoveDocument(docVersion.getRef());
    }

    @Override
    public boolean getCanRemoveSelectedArchivedVersions() {
        List currentVersionSelection = this.documentsListsManager.getWorkingList("CURRENT_SELECTION_VERSIONS");
        if (currentVersionSelection != null && currentVersionSelection.size() > 0) {
            for (DocumentModel version : currentVersionSelection) {
                if (this.documentManager.canRemoveDocument(version.getRef())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String removeArchivedVersion(VersionModel selectedVersion) {
        DocumentRef docRef = this.navigationContext.getCurrentDocument().getRef();
        DocumentModel docVersion = this.documentManager.getDocumentWithVersion(docRef, selectedVersion);
        if (docVersion == null) {
            log.warn((Object)("Unexpectedly couldn't find the version " + selectedVersion.getLabel()));
            return null;
        }
        this.documentManager.removeDocument(docVersion.getRef());
        this.documentManager.save();
        this.resetVersions();
        this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("feedback.versioning.versionRemoved"), new Object[0]);
        return null;
    }

    @Override
    public String removeSelectedArchivedVersions() {
        List currentVersionSelection = this.documentsListsManager.getWorkingList("CURRENT_SELECTION_VERSIONS");
        if (currentVersionSelection == null || currentVersionSelection.isEmpty()) {
            log.warn((Object)"Currently selected version list is null or empty, cannot remove any version.");
            return null;
        }
        for (DocumentModel version : currentVersionSelection) {
            if (version == null) continue;
            this.documentManager.removeDocument(version.getRef());
        }
        this.documentManager.save();
        this.resetVersions();
        this.documentsListsManager.removeFromAllLists(new ArrayList(currentVersionSelection));
        this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("feedback.versioning.versionsRemoved"), new Object[0]);
        return null;
    }

    @Override
    public String getSelectedVersionId() {
        return this.selectedVersionId;
    }

    @Override
    public void setSelectedVersionId(String selectedVersionId) {
        this.selectedVersionId = selectedVersionId;
    }
}

