/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.user.center.profile.rest;

import java.io.IOException;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.ecm.core.io.marshallers.json.enrichers.AbstractJsonEnricher;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.user.center.profile.UserProfileService;
import org.nuxeo.runtime.api.Framework;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class UserProfileEnricher
extends AbstractJsonEnricher<NuxeoPrincipal> {
    private static final DateFormat FORMATTER = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    public static final String NAME = "userprofile";

    public UserProfileEnricher() {
        super(NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(JsonGenerator jg, NuxeoPrincipal nuxeoPrincipal) throws IOException {
        block18: {
            UserProfileService ups = (UserProfileService)Framework.getLocalService(UserProfileService.class);
            try (RenderingContext.SessionWrapper sw = this.ctx.getSession(null);){
                DocumentModel up = ups.getUserProfileDocument(nuxeoPrincipal.getName(), sw.getSession());
                jg.writeFieldName(NAME);
                if (up == null) {
                    jg.writeNull();
                    break block18;
                }
                try {
                    jg.writeStartObject();
                    Serializable propertyValue = up.getPropertyValue("userprofile:birthdate");
                    jg.writeStringField("birthdate", propertyValue == null ? null : FORMATTER.format(((GregorianCalendar)propertyValue).getTime()));
                    jg.writeStringField("phonenumber", (String)((Object)up.getPropertyValue("userprofile:phonenumber")));
                    Blob avatar = (Blob)up.getPropertyValue("userprofile:avatar");
                    if (avatar != null) {
                        DownloadService downloadService = (DownloadService)Framework.getService(DownloadService.class);
                        String url = downloadService.getDownloadUrl(up, "userprofile:avatar", avatar.getFilename());
                        jg.writeStringField("avatar", this.ctx.getBaseUrl() + url);
                    } else {
                        jg.writeNullField("avatar");
                    }
                }
                finally {
                    jg.writeEndObject();
                }
            }
        }
    }
}

