/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util;

import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.util.Matrix;
import org.apache.pdfbox.util.TextNormalize;

public class TextPosition {
    private Matrix textPos;
    private float endX;
    private float endY;
    private float maxTextHeight;
    private int rot;
    private float x = Float.NEGATIVE_INFINITY;
    private float y = Float.NEGATIVE_INFINITY;
    private float pageHeight;
    private float pageWidth;
    private float[] widths;
    private float widthOfSpace;
    private String str;
    private int[] unicodeCP;
    private PDFont font;
    private float fontSize;
    private int fontSizePt;
    private float wordSpacing;

    protected TextPosition() {
    }

    public TextPosition(PDPage page, Matrix textPositionSt, Matrix textPositionEnd, float maxFontH, float[] individualWidths, float spaceWidth, String string, PDFont currentFont, float fontSizeValue, int fontSizeInPt, float ws) {
        this.textPos = textPositionSt;
        this.endX = textPositionEnd.getXPosition();
        this.endY = textPositionEnd.getYPosition();
        this.rot = page.findRotation();
        if (this.rot < 0) {
            this.rot += 360;
        } else if (this.rot >= 360) {
            this.rot -= 360;
        }
        this.maxTextHeight = maxFontH;
        this.pageHeight = page.findMediaBox().getHeight();
        this.pageWidth = page.findMediaBox().getWidth();
        this.widths = individualWidths;
        this.widthOfSpace = spaceWidth;
        this.str = string;
        this.font = currentFont;
        this.fontSize = fontSizeValue;
        this.fontSizePt = fontSizeInPt;
        this.wordSpacing = ws;
    }

    public TextPosition(int pageRotation, float pageWidthValue, float pageHeightValue, Matrix textPositionSt, Matrix textPositionEnd, float maxFontH, float individualWidth, float spaceWidth, String string, PDFont currentFont, float fontSizeValue, int fontSizeInPt) {
        this(pageRotation, pageWidthValue, pageHeightValue, textPositionSt, textPositionEnd.getXPosition(), textPositionEnd.getYPosition(), maxFontH, individualWidth, spaceWidth, string, null, currentFont, fontSizeValue, fontSizeInPt);
    }

    public TextPosition(int pageRotation, float pageWidthValue, float pageHeightValue, Matrix textPositionSt, float endXValue, float endYValue, float maxFontH, float individualWidth, float spaceWidth, String string, PDFont currentFont, float fontSizeValue, int fontSizeInPt) {
        this(pageRotation, pageWidthValue, pageHeightValue, textPositionSt, endXValue, endYValue, maxFontH, individualWidth, spaceWidth, string, null, currentFont, fontSizeValue, fontSizeInPt);
    }

    public TextPosition(int pageRotation, float pageWidthValue, float pageHeightValue, Matrix textPositionSt, float endXValue, float endYValue, float maxFontH, float individualWidth, float spaceWidth, String string, int[] codePoints, PDFont currentFont, float fontSizeValue, int fontSizeInPt) {
        this.textPos = textPositionSt;
        this.endX = endXValue;
        this.endY = endYValue;
        while (pageRotation < 0) {
            pageRotation += 360;
        }
        while (pageRotation >= 360) {
            pageRotation -= 360;
        }
        this.rot = pageRotation;
        this.maxTextHeight = maxFontH;
        this.pageHeight = pageHeightValue;
        this.pageWidth = pageWidthValue;
        this.widths = new float[]{individualWidth};
        this.widthOfSpace = spaceWidth;
        this.str = string;
        this.unicodeCP = codePoints;
        this.font = currentFont;
        this.fontSize = fontSizeValue;
        this.fontSizePt = fontSizeInPt;
    }

    public String getCharacter() {
        return this.str;
    }

    public int[] getCodePoints() {
        return this.unicodeCP;
    }

    public Matrix getTextPos() {
        return this.textPos;
    }

    public float getDir() {
        float a = this.textPos.getValue(0, 0);
        float b = this.textPos.getValue(0, 1);
        float c = this.textPos.getValue(1, 0);
        float d = this.textPos.getValue(1, 1);
        if (a > 0.0f && Math.abs(b) < d && Math.abs(c) < a && d > 0.0f) {
            return 0.0f;
        }
        if (a < 0.0f && Math.abs(b) < Math.abs(d) && Math.abs(c) < Math.abs(a) && d < 0.0f) {
            return 180.0f;
        }
        if (Math.abs(a) < Math.abs(c) && b > 0.0f && c < 0.0f && Math.abs(d) < b) {
            return 90.0f;
        }
        if (Math.abs(a) < c && b < 0.0f && c > 0.0f && Math.abs(d) < Math.abs(b)) {
            return 270.0f;
        }
        return 0.0f;
    }

    private float getXRot(float rotation) {
        if (rotation == 0.0f) {
            return this.textPos.getValue(2, 0);
        }
        if (rotation == 90.0f) {
            return this.textPos.getValue(2, 1);
        }
        if (rotation == 180.0f) {
            return this.pageWidth - this.textPos.getValue(2, 0);
        }
        if (rotation == 270.0f) {
            return this.pageHeight - this.textPos.getValue(2, 1);
        }
        return 0.0f;
    }

    public float getX() {
        if (this.x == Float.NEGATIVE_INFINITY) {
            this.x = this.getXRot(this.rot);
        }
        return this.x;
    }

    public float getXDirAdj() {
        return this.getXRot(this.getDir());
    }

    private float getYLowerLeftRot(float rotation) {
        if (rotation == 0.0f) {
            return this.textPos.getValue(2, 1);
        }
        if (rotation == 90.0f) {
            return this.pageWidth - this.textPos.getValue(2, 0);
        }
        if (rotation == 180.0f) {
            return this.pageHeight - this.textPos.getValue(2, 1);
        }
        if (rotation == 270.0f) {
            return this.textPos.getValue(2, 0);
        }
        return 0.0f;
    }

    public float getY() {
        if (this.y == Float.NEGATIVE_INFINITY) {
            this.y = this.rot == 0 || this.rot == 180 ? this.pageHeight - this.getYLowerLeftRot(this.rot) : this.pageWidth - this.getYLowerLeftRot(this.rot);
        }
        return this.y;
    }

    public float getYDirAdj() {
        float dir = this.getDir();
        if (dir == 0.0f || dir == 180.0f) {
            return this.pageHeight - this.getYLowerLeftRot(dir);
        }
        return this.pageWidth - this.getYLowerLeftRot(dir);
    }

    private float getWidthRot(float rotation) {
        if (rotation == 90.0f || rotation == 270.0f) {
            return Math.abs(this.endY - this.textPos.getYPosition());
        }
        return Math.abs(this.endX - this.textPos.getXPosition());
    }

    public float getWidth() {
        return this.getWidthRot(this.rot);
    }

    public float getWidthDirAdj() {
        return this.getWidthRot(this.getDir());
    }

    public float getHeight() {
        return this.maxTextHeight;
    }

    public float getHeightDir() {
        return this.maxTextHeight;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public float getFontSizeInPt() {
        return this.fontSizePt;
    }

    public PDFont getFont() {
        return this.font;
    }

    @Deprecated
    public float getWordSpacing() {
        return this.wordSpacing;
    }

    public float getWidthOfSpace() {
        return this.widthOfSpace;
    }

    public float getXScale() {
        return this.textPos.getXScale();
    }

    public float getYScale() {
        return this.textPos.getYScale();
    }

    public float[] getIndividualWidths() {
        return this.widths;
    }

    public String toString() {
        return this.getCharacter();
    }

    public boolean contains(TextPosition tp2) {
        double thisXstart = this.getXDirAdj();
        double thisXend = this.getXDirAdj() + this.getWidthDirAdj();
        double tp2Xstart = tp2.getXDirAdj();
        double tp2Xend = tp2.getXDirAdj() + tp2.getWidthDirAdj();
        if (tp2Xend <= thisXstart || tp2Xstart >= thisXend) {
            return false;
        }
        if (tp2.getYDirAdj() + tp2.getHeightDir() < this.getYDirAdj() || tp2.getYDirAdj() > this.getYDirAdj() + this.getHeightDir()) {
            return false;
        }
        if (tp2Xstart > thisXstart && tp2Xend > thisXend) {
            double overlap = thisXend - tp2Xstart;
            double overlapPercent = overlap / (double)this.getWidthDirAdj();
            return overlapPercent > 0.15;
        }
        if (tp2Xstart < thisXstart && tp2Xend < thisXend) {
            double overlap = tp2Xend - thisXstart;
            double overlapPercent = overlap / (double)this.getWidthDirAdj();
            return overlapPercent > 0.15;
        }
        return true;
    }

    public void mergeDiacritic(TextPosition diacritic, TextNormalize normalize) {
        if (diacritic.getCharacter().length() > 1) {
            return;
        }
        float diacXStart = diacritic.getXDirAdj();
        float diacXEnd = diacXStart + diacritic.widths[0];
        float currCharXStart = this.getXDirAdj();
        int strLen = this.str.length();
        boolean wasAdded = false;
        for (int i = 0; i < strLen && !wasAdded; ++i) {
            float currCharXEnd = currCharXStart + this.widths[i];
            if (diacXStart < currCharXStart && diacXEnd <= currCharXEnd) {
                if (i == 0) {
                    this.insertDiacritic(i, diacritic, normalize);
                } else {
                    float distanceOverlapping1 = diacXEnd - currCharXStart;
                    float percentage1 = distanceOverlapping1 / this.widths[i];
                    float distanceOverlapping2 = currCharXStart - diacXStart;
                    float percentage2 = distanceOverlapping2 / this.widths[i - 1];
                    if (percentage1 >= percentage2) {
                        this.insertDiacritic(i, diacritic, normalize);
                    } else {
                        this.insertDiacritic(i - 1, diacritic, normalize);
                    }
                }
                wasAdded = true;
            } else if (diacXStart < currCharXStart && diacXEnd > currCharXEnd) {
                this.insertDiacritic(i, diacritic, normalize);
                wasAdded = true;
            } else if (diacXStart >= currCharXStart && diacXEnd <= currCharXEnd) {
                this.insertDiacritic(i, diacritic, normalize);
                wasAdded = true;
            } else if (diacXStart >= currCharXStart && diacXEnd > currCharXEnd && i == strLen - 1) {
                this.insertDiacritic(i, diacritic, normalize);
                wasAdded = true;
            }
            currCharXStart += this.widths[i];
        }
    }

    private void insertDiacritic(int i, TextPosition diacritic, TextNormalize normalize) {
        byte dir = Character.getDirectionality(this.str.charAt(i));
        StringBuffer buf = new StringBuffer();
        buf.append(this.str.substring(0, i));
        float[] widths2 = new float[this.widths.length + 1];
        System.arraycopy(this.widths, 0, widths2, 0, i);
        if (dir == 1 || dir == 2 || dir == 16 || dir == 17) {
            buf.append(normalize.normalizeDiac(diacritic.getCharacter()));
            widths2[i] = 0.0f;
            buf.append(this.str.charAt(i));
            widths2[i + 1] = this.widths[i];
        } else {
            buf.append(this.str.charAt(i));
            widths2[i] = this.widths[i];
            buf.append(normalize.normalizeDiac(diacritic.getCharacter()));
            widths2[i + 1] = 0.0f;
        }
        buf.append(this.str.substring(i + 1, this.str.length()));
        System.arraycopy(this.widths, i + 1, widths2, i + 2, this.widths.length - i - 1);
        this.str = buf.toString();
        this.widths = widths2;
    }

    public boolean isDiacritic() {
        String cText = this.getCharacter();
        if (cText.length() != 1) {
            return false;
        }
        int type = Character.getType(cText.charAt(0));
        return type == 6 || type == 27 || type == 4;
    }
}

