/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.services;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.persistence.PersistenceProvider;
import org.nuxeo.ecm.core.persistence.PersistenceProviderFactory;
import org.nuxeo.ecm.platform.audit.api.AuditReader;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Audit.Query", category="Services", label="Query Audit Service", description="Execute a JPA query against the Audit Service. This is returning a blob with the query result. The result is a serialized JSON array. You can use the context to set query variables but you must prefix using 'audit.query.' the context variable keys that match the ones in the query.", addToStudio=false)
public class AuditQuery {
    public static final String ID = "Audit.Query";
    @Context
    protected AuditReader audit;
    @Context
    protected OperationContext ctx;
    @Param(name="query", required=true, widget="TextArea")
    protected String query;
    @Param(name="pageNo", required=false)
    protected int pageNo = 1;
    @Param(name="maxResults", required=false)
    protected int maxResults;

    @OperationMethod
    public Blob run() {
        List<LogEntry> result = this.query();
        JSONArray rows = new JSONArray();
        for (LogEntry entry : result) {
            JSONObject obj = new JSONObject();
            obj.element("eventId", (Object)entry.getEventId());
            obj.element("category", (Object)entry.getCategory());
            obj.element("eventDate", entry.getEventDate().getTime());
            obj.element("principal", (Object)entry.getPrincipalName());
            obj.element("docUUID", (Object)entry.getDocUUID());
            obj.element("docType", (Object)entry.getDocType());
            obj.element("docPath", (Object)entry.getDocPath());
            obj.element("docLifeCycle", (Object)entry.getDocLifeCycle());
            obj.element("repoId", (Object)entry.getRepositoryId());
            obj.element("comment", (Object)entry.getComment());
            rows.add((Object)obj);
        }
        return Blobs.createBlob((String)rows.toString(), (String)"application/json");
    }

    public List<LogEntry> query() {
        PersistenceProviderFactory pf = (PersistenceProviderFactory)Framework.getService(PersistenceProviderFactory.class);
        PersistenceProvider provider = pf.newProvider("nxaudit-logs");
        return (List)provider.run(Boolean.valueOf(false), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<List<LogEntry>>(){

            public List<LogEntry> runWith(EntityManager em) {
                Query q = em.createQuery(AuditQuery.this.query);
                if (AuditQuery.this.maxResults > 0) {
                    q.setMaxResults(AuditQuery.this.maxResults);
                    q.setFirstResult((AuditQuery.this.pageNo - 1) * AuditQuery.this.maxResults);
                }
                for (Map.Entry entry : AuditQuery.this.ctx.entrySet()) {
                    String key = (String)entry.getKey();
                    if (!key.startsWith("audit.query.")) continue;
                    AuditQuery.this.setQueryParam(q, key.substring("audit.query.".length()), entry.getValue());
                }
                return q.getResultList();
            }
        });
    }

    protected void setQueryParam(Query q, String key, Object value) {
        if (value instanceof String) {
            String v = (String)value;
            if (v.startsWith("{d ") && v.endsWith("}")) {
                int i = (v = v.substring(3, v.length() - 1).trim()).indexOf(32);
                if (i == -1) {
                    Date date = Date.valueOf(v);
                    q.setParameter(key, (Object)date);
                } else {
                    Timestamp ts = Timestamp.valueOf(v);
                    q.setParameter(key, (Object)ts);
                }
            } else {
                q.setParameter(key, (Object)v);
            }
        } else {
            q.setParameter(key, value);
        }
    }
}

