/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.jackson.dataformat.cbor;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import org.elasticsearch.common.jackson.core.Base64Variant;
import org.elasticsearch.common.jackson.core.JsonLocation;
import org.elasticsearch.common.jackson.core.JsonParseException;
import org.elasticsearch.common.jackson.core.JsonParser;
import org.elasticsearch.common.jackson.core.JsonToken;
import org.elasticsearch.common.jackson.core.ObjectCodec;
import org.elasticsearch.common.jackson.core.Version;
import org.elasticsearch.common.jackson.core.base.ParserMinimalBase;
import org.elasticsearch.common.jackson.core.io.IOContext;
import org.elasticsearch.common.jackson.core.io.NumberInput;
import org.elasticsearch.common.jackson.core.json.DupDetector;
import org.elasticsearch.common.jackson.core.sym.BytesToNameCanonicalizer;
import org.elasticsearch.common.jackson.core.sym.Name;
import org.elasticsearch.common.jackson.core.util.ByteArrayBuilder;
import org.elasticsearch.common.jackson.core.util.TextBuffer;
import org.elasticsearch.common.jackson.dataformat.cbor.CBORConstants;
import org.elasticsearch.common.jackson.dataformat.cbor.CBORReadContext;
import org.elasticsearch.common.jackson.dataformat.cbor.PackageVersion;

public final class CBORParser
extends ParserMinimalBase {
    private static final int[] NO_INTS = new int[0];
    private static final int[] UTF8_UNIT_CODES = CBORConstants.sUtf8UnitLengths;
    private static final double MATH_POW_2_10 = Math.pow(2.0, 10.0);
    private static final double MATH_POW_2_NEG14 = Math.pow(2.0, -14.0);
    protected ObjectCodec _objectCodec;
    protected final IOContext _ioContext;
    protected boolean _closed;
    protected int _inputPtr = 0;
    protected int _inputEnd = 0;
    protected long _currInputProcessed = 0L;
    protected int _currInputRow = 1;
    protected int _currInputRowStart = 0;
    protected long _tokenInputTotal = 0L;
    protected int _tokenInputRow = 1;
    protected int _tokenInputCol = 0;
    protected CBORReadContext _parsingContext;
    protected final TextBuffer _textBuffer;
    protected char[] _nameCopyBuffer = null;
    protected boolean _nameCopied = false;
    protected ByteArrayBuilder _byteArrayBuilder = null;
    protected byte[] _binaryValue;
    protected int _tagValue = -1;
    protected InputStream _inputStream;
    protected byte[] _inputBuffer;
    protected boolean _bufferRecyclable;
    protected boolean _tokenIncomplete = false;
    protected int _typeByte;
    private int _chunkLeft;
    private int _chunkEnd;
    protected final BytesToNameCanonicalizer _symbols;
    protected int[] _quadBuffer = NO_INTS;
    protected int _quad1;
    protected int _quad2;
    protected static final int NR_UNKNOWN = 0;
    protected static final int NR_INT = 1;
    protected static final int NR_LONG = 2;
    protected static final int NR_BIGINT = 4;
    protected static final int NR_DOUBLE = 8;
    protected static final int NR_BIGDECIMAL = 16;
    static final BigInteger BI_MIN_INT = BigInteger.valueOf(Integer.MIN_VALUE);
    static final BigInteger BI_MAX_INT = BigInteger.valueOf(Integer.MAX_VALUE);
    static final BigInteger BI_MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
    static final BigInteger BI_MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    static final BigDecimal BD_MIN_LONG = new BigDecimal(BI_MIN_LONG);
    static final BigDecimal BD_MAX_LONG = new BigDecimal(BI_MAX_LONG);
    static final BigDecimal BD_MIN_INT = new BigDecimal(BI_MIN_INT);
    static final BigDecimal BD_MAX_INT = new BigDecimal(BI_MAX_INT);
    static final long MIN_INT_L = Integer.MIN_VALUE;
    static final long MAX_INT_L = Integer.MAX_VALUE;
    static final double MIN_LONG_D = -9.223372036854776E18;
    static final double MAX_LONG_D = 9.223372036854776E18;
    static final double MIN_INT_D = -2.147483648E9;
    static final double MAX_INT_D = 2.147483647E9;
    protected static final int INT_0 = 48;
    protected static final int INT_9 = 57;
    protected static final int INT_MINUS = 45;
    protected static final int INT_PLUS = 43;
    protected static final char CHAR_NULL = '\u0000';
    protected int _numTypesValid = 0;
    protected int _numberInt;
    protected long _numberLong;
    protected double _numberDouble;
    protected BigInteger _numberBigInt;
    protected BigDecimal _numberBigDecimal;

    public CBORParser(IOContext ctxt, int parserFeatures, int cborFeatures, ObjectCodec codec, BytesToNameCanonicalizer sym, InputStream in, byte[] inputBuffer, int start, int end, boolean bufferRecyclable) {
        super(parserFeatures);
        this._ioContext = ctxt;
        this._objectCodec = codec;
        this._symbols = sym;
        this._inputStream = in;
        this._inputBuffer = inputBuffer;
        this._inputPtr = start;
        this._inputEnd = end;
        this._bufferRecyclable = bufferRecyclable;
        this._textBuffer = ctxt.constructTextBuffer();
        DupDetector dups = JsonParser.Feature.STRICT_DUPLICATE_DETECTION.enabledIn(parserFeatures) ? DupDetector.rootDetector(this) : null;
        this._parsingContext = CBORReadContext.createRootContext(dups);
        this._tokenInputRow = -1;
        this._tokenInputCol = -1;
    }

    @Override
    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    @Override
    public void setCodec(ObjectCodec c) {
        this._objectCodec = c;
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public int releaseBuffered(OutputStream out) throws IOException {
        int count = this._inputEnd - this._inputPtr;
        if (count < 1) {
            return 0;
        }
        int origPtr = this._inputPtr;
        out.write(this._inputBuffer, origPtr, count);
        return count;
    }

    @Override
    public Object getInputSource() {
        return this._inputStream;
    }

    @Override
    public JsonLocation getTokenLocation() {
        return new JsonLocation(this._ioContext.getSourceReference(), this._tokenInputTotal, -1L, -1, (int)this._tokenInputTotal);
    }

    @Override
    public JsonLocation getCurrentLocation() {
        long offset = this._currInputProcessed + (long)this._inputPtr;
        return new JsonLocation(this._ioContext.getSourceReference(), offset, -1L, -1, (int)offset);
    }

    @Override
    public String getCurrentName() throws IOException {
        if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
            CBORReadContext parent = this._parsingContext.getParent();
            return parent.getCurrentName();
        }
        return this._parsingContext.getCurrentName();
    }

    @Override
    public void overrideCurrentName(String name) {
        CBORReadContext ctxt = this._parsingContext;
        if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
            ctxt = ctxt.getParent();
        }
        try {
            ctxt.setCurrentName(name);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this._closed) {
            this._closed = true;
            this._symbols.release();
            try {
                this._closeInput();
            }
            finally {
                this._releaseBuffers();
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this._closed;
    }

    @Override
    public CBORReadContext getParsingContext() {
        return this._parsingContext;
    }

    @Override
    public boolean hasTextCharacters() {
        if (this._currToken == JsonToken.VALUE_STRING) {
            return this._textBuffer.hasTextAsCharacters();
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this._nameCopied;
        }
        return false;
    }

    protected void _releaseBuffers() throws IOException {
        Object[] buf;
        if (this._bufferRecyclable && (buf = this._inputBuffer) != null) {
            this._inputBuffer = null;
            this._ioContext.releaseReadIOBuffer((byte[])buf);
        }
        this._textBuffer.releaseBuffers();
        buf = this._nameCopyBuffer;
        if (buf != null) {
            this._nameCopyBuffer = null;
            this._ioContext.releaseNameCopyBuffer((char[])buf);
        }
    }

    @Override
    public JsonToken nextToken() throws IOException {
        this._numTypesValid = 0;
        this._tagValue = -1;
        if (this._tokenIncomplete) {
            this._skipIncomplete();
        }
        this._tokenInputTotal = this._currInputProcessed + (long)this._inputPtr;
        this._binaryValue = null;
        if (this._parsingContext.inObject()) {
            if (this._currToken != JsonToken.FIELD_NAME) {
                if (!this._parsingContext.expectMoreValues()) {
                    this._parsingContext = this._parsingContext.getParent();
                    this._currToken = JsonToken.END_OBJECT;
                    return this._currToken;
                }
                this._currToken = this._decodeFieldName();
                return this._currToken;
            }
        } else if (!this._parsingContext.expectMoreValues()) {
            this._parsingContext = this._parsingContext.getParent();
            this._currToken = JsonToken.END_ARRAY;
            return this._currToken;
        }
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._handleEOF();
            this.close();
            this._currToken = null;
            return null;
        }
        int ch = this._inputBuffer[this._inputPtr++];
        int lowBits = ch & 0x1F;
        switch (ch >> 5 & 7) {
            case 0: {
                this._numTypesValid = 1;
                if (lowBits <= 23) {
                    this._numberInt = lowBits;
                } else {
                    switch (lowBits - 24) {
                        case 0: {
                            this._numberInt = this._decode8Bits();
                            break;
                        }
                        case 1: {
                            this._numberInt = this._decode16Bits();
                            break;
                        }
                        case 2: {
                            this._numberInt = this._decode32Bits();
                            break;
                        }
                        case 3: {
                            this._numberLong = this._decode64Bits();
                            this._numTypesValid = 2;
                            break;
                        }
                        default: {
                            this._invalidToken(ch);
                        }
                    }
                }
                this._currToken = JsonToken.VALUE_NUMBER_INT;
                return this._currToken;
            }
            case 1: {
                this._numTypesValid = 1;
                if (lowBits <= 23) {
                    this._numberInt = -lowBits - 1;
                } else {
                    switch (lowBits - 24) {
                        case 0: {
                            this._numberInt = -this._decode8Bits() - 1;
                            break;
                        }
                        case 1: {
                            this._numberInt = -this._decode16Bits() - 1;
                            break;
                        }
                        case 2: {
                            this._numberInt = -this._decode32Bits() - 1;
                            break;
                        }
                        case 3: {
                            this._numberLong = -this._decode64Bits() - 1L;
                            this._numTypesValid = 2;
                            break;
                        }
                        default: {
                            this._invalidToken(ch);
                        }
                    }
                }
                this._currToken = JsonToken.VALUE_NUMBER_INT;
                return this._currToken;
            }
            case 2: {
                this._typeByte = ch;
                this._tokenIncomplete = true;
                this._currToken = JsonToken.VALUE_EMBEDDED_OBJECT;
                return this._currToken;
            }
            case 3: {
                this._typeByte = ch;
                this._tokenIncomplete = true;
                this._currToken = JsonToken.VALUE_STRING;
                return this._currToken;
            }
            case 4: {
                this._currToken = JsonToken.START_ARRAY;
                int len = this._decodeExplicitLength(lowBits);
                this._parsingContext = this._parsingContext.createChildArrayContext(len);
                return this._currToken;
            }
            case 5: {
                this._currToken = JsonToken.START_OBJECT;
                int len = this._decodeExplicitLength(lowBits);
                this._parsingContext = this._parsingContext.createChildObjectContext(len);
                return this._currToken;
            }
            case 6: {
                this._tagValue = this._decodeTag(lowBits);
                return this.nextToken();
            }
        }
        switch (lowBits) {
            case 20: {
                this._currToken = JsonToken.VALUE_FALSE;
                return this._currToken;
            }
            case 21: {
                this._currToken = JsonToken.VALUE_TRUE;
                return this._currToken;
            }
            case 22: {
                this._currToken = JsonToken.VALUE_NULL;
                return this._currToken;
            }
            case 25: {
                float f = (float)this._decodeHalfSizeFloat();
                this._numberDouble = f;
                this._numTypesValid = 8;
                this._currToken = JsonToken.VALUE_NUMBER_FLOAT;
                return this._currToken;
            }
            case 26: {
                float f = Float.intBitsToFloat(this._decode32Bits());
                this._numberDouble = f;
                this._numTypesValid = 8;
                this._currToken = JsonToken.VALUE_NUMBER_FLOAT;
                return this._currToken;
            }
            case 27: {
                this._numberDouble = Double.longBitsToDouble(this._decode64Bits());
                this._numTypesValid = 8;
                this._currToken = JsonToken.VALUE_NUMBER_FLOAT;
                return this._currToken;
            }
            case 31: {
                if (this._parsingContext.inArray() && !this._parsingContext.hasExpectedLength()) {
                    this._parsingContext = this._parsingContext.getParent();
                    this._currToken = JsonToken.END_ARRAY;
                    return this._currToken;
                }
                this._reportUnexpectedBreak();
            }
        }
        this._invalidToken(ch);
        return null;
    }

    protected String _numberToName(int ch, boolean neg) throws IOException {
        int i;
        int lowBits = ch & 0x1F;
        if (lowBits <= 23) {
            i = lowBits;
        } else {
            switch (lowBits) {
                case 24: {
                    i = this._decode8Bits();
                    break;
                }
                case 25: {
                    i = this._decode16Bits();
                    break;
                }
                case 26: {
                    i = this._decode32Bits();
                    break;
                }
                case 27: {
                    long l = this._decode64Bits();
                    if (neg) {
                        l = -l - 1L;
                    }
                    return String.valueOf(l);
                }
                default: {
                    throw this._constructError("Invalid length indicator for ints (" + lowBits + "), token 0x" + Integer.toHexString(ch));
                }
            }
        }
        if (neg) {
            i = -i - 1;
        }
        return String.valueOf(1);
    }

    protected void _invalidToken(int ch) throws JsonParseException {
        if ((ch &= 0xFF) == 255) {
            throw this._constructError("Mismatched BREAK byte (0xFF): encountered where value expected");
        }
        throw this._constructError("Invalid CBOR value token (first byte): 0x" + Integer.toHexString(ch));
    }

    @Override
    public int nextIntValue(int defaultValue) throws IOException {
        if (this.nextToken() == JsonToken.VALUE_NUMBER_INT) {
            return this.getIntValue();
        }
        return defaultValue;
    }

    @Override
    public long nextLongValue(long defaultValue) throws IOException {
        if (this.nextToken() == JsonToken.VALUE_NUMBER_INT) {
            return this.getLongValue();
        }
        return defaultValue;
    }

    @Override
    public Boolean nextBooleanValue() throws IOException {
        switch (this.nextToken()) {
            case VALUE_TRUE: {
                return Boolean.TRUE;
            }
            case VALUE_FALSE: {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    @Override
    public String getText() throws IOException {
        if (this._tokenIncomplete) {
            this._finishToken();
        }
        if (this._currToken == JsonToken.VALUE_STRING) {
            return this._textBuffer.contentsAsString();
        }
        JsonToken t = this._currToken;
        if (t == null) {
            return null;
        }
        if (t == JsonToken.FIELD_NAME) {
            return this._parsingContext.getCurrentName();
        }
        if (t.isNumeric()) {
            return this.getNumberValue().toString();
        }
        return this._currToken.asString();
    }

    @Override
    public char[] getTextCharacters() throws IOException {
        if (this._currToken != null) {
            if (this._tokenIncomplete) {
                this._finishToken();
            }
            switch (this._currToken) {
                case VALUE_STRING: {
                    return this._textBuffer.getTextBuffer();
                }
                case FIELD_NAME: {
                    return this._parsingContext.getCurrentName().toCharArray();
                }
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    return this.getNumberValue().toString().toCharArray();
                }
            }
            return this._currToken.asCharArray();
        }
        return null;
    }

    @Override
    public int getTextLength() throws IOException {
        if (this._currToken != null) {
            if (this._tokenIncomplete) {
                this._finishToken();
            }
            switch (this._currToken) {
                case VALUE_STRING: {
                    return this._textBuffer.size();
                }
                case FIELD_NAME: {
                    return this._parsingContext.getCurrentName().length();
                }
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    return this.getNumberValue().toString().length();
                }
            }
            return this._currToken.asCharArray().length;
        }
        return 0;
    }

    @Override
    public int getTextOffset() throws IOException {
        return 0;
    }

    @Override
    public String getValueAsString() throws IOException {
        if (!(this._currToken == JsonToken.VALUE_STRING || this._currToken != null && this._currToken != JsonToken.VALUE_NULL && this._currToken.isScalarValue())) {
            return null;
        }
        return this.getText();
    }

    @Override
    public String getValueAsString(String defaultValue) throws IOException {
        if (!(this._currToken == JsonToken.VALUE_STRING || this._currToken != null && this._currToken != JsonToken.VALUE_NULL && this._currToken.isScalarValue())) {
            return defaultValue;
        }
        return this.getText();
    }

    @Override
    public byte[] getBinaryValue(Base64Variant b64variant) throws IOException {
        if (this._tokenIncomplete) {
            this._finishToken();
        }
        if (this._currToken != JsonToken.VALUE_EMBEDDED_OBJECT) {
            this._reportError("Current token (" + (Object)((Object)this._currToken) + ") not VALUE_EMBEDDED_OBJECT, can not access as binary");
        }
        return this._binaryValue;
    }

    @Override
    public Object getEmbeddedObject() throws IOException {
        if (this._tokenIncomplete) {
            this._finishToken();
        }
        if (this._currToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
            return this._binaryValue;
        }
        return null;
    }

    @Override
    public int readBinaryValue(Base64Variant b64variant, OutputStream out) throws IOException {
        if (this._currToken != JsonToken.VALUE_EMBEDDED_OBJECT) {
            this._reportError("Current token (" + (Object)((Object)this._currToken) + ") not VALUE_EMBEDDED_OBJECT, can not access as binary");
        }
        if (!this._tokenIncomplete) {
            if (this._binaryValue == null) {
                return 0;
            }
            int len = this._binaryValue.length;
            out.write(this._binaryValue, 0, len);
            return len;
        }
        this._tokenIncomplete = false;
        int len = this._decodeExplicitLength(this._typeByte & 0x1F);
        if (len >= 0) {
            return this._readAndWriteBytes(out, len);
        }
        int total = 0;
        while ((len = this._decodeChunkLength(2)) >= 0) {
            total += this._readAndWriteBytes(out, len);
        }
        return total;
    }

    private int _readAndWriteBytes(OutputStream out, int total) throws IOException {
        int count;
        for (int left = total; left > 0; left -= count) {
            int avail = this._inputEnd - this._inputPtr;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
                avail = this._inputEnd - this._inputPtr;
            }
            count = Math.min(avail, left);
            out.write(this._inputBuffer, this._inputPtr, count);
            this._inputPtr += count;
        }
        this._tokenIncomplete = false;
        return total;
    }

    @Override
    public Number getNumberValue() throws IOException {
        if (this._numTypesValid == 0) {
            this._checkNumericValue(0);
        }
        if (this._currToken == JsonToken.VALUE_NUMBER_INT) {
            if ((this._numTypesValid & 1) != 0) {
                return this._numberInt;
            }
            if ((this._numTypesValid & 2) != 0) {
                return this._numberLong;
            }
            if ((this._numTypesValid & 4) != 0) {
                return this._numberBigInt;
            }
            return this._numberBigDecimal;
        }
        if ((this._numTypesValid & 0x10) != 0) {
            return this._numberBigDecimal;
        }
        if ((this._numTypesValid & 8) == 0) {
            this._throwInternal();
        }
        return this._numberDouble;
    }

    @Override
    public JsonParser.NumberType getNumberType() throws IOException {
        if (this._numTypesValid == 0) {
            this._checkNumericValue(0);
        }
        if (this._currToken == JsonToken.VALUE_NUMBER_INT) {
            if ((this._numTypesValid & 1) != 0) {
                return JsonParser.NumberType.INT;
            }
            if ((this._numTypesValid & 2) != 0) {
                return JsonParser.NumberType.LONG;
            }
            return JsonParser.NumberType.BIG_INTEGER;
        }
        if ((this._numTypesValid & 0x10) != 0) {
            return JsonParser.NumberType.BIG_DECIMAL;
        }
        return JsonParser.NumberType.DOUBLE;
    }

    @Override
    public int getIntValue() throws IOException {
        if ((this._numTypesValid & 1) == 0) {
            if (this._numTypesValid == 0) {
                this._checkNumericValue(1);
            }
            if ((this._numTypesValid & 1) == 0) {
                this.convertNumberToInt();
            }
        }
        return this._numberInt;
    }

    @Override
    public long getLongValue() throws IOException {
        if ((this._numTypesValid & 2) == 0) {
            if (this._numTypesValid == 0) {
                this._checkNumericValue(2);
            }
            if ((this._numTypesValid & 2) == 0) {
                this.convertNumberToLong();
            }
        }
        return this._numberLong;
    }

    @Override
    public BigInteger getBigIntegerValue() throws IOException {
        if ((this._numTypesValid & 4) == 0) {
            if (this._numTypesValid == 0) {
                this._checkNumericValue(4);
            }
            if ((this._numTypesValid & 4) == 0) {
                this.convertNumberToBigInteger();
            }
        }
        return this._numberBigInt;
    }

    @Override
    public float getFloatValue() throws IOException {
        double value = this.getDoubleValue();
        return (float)value;
    }

    @Override
    public double getDoubleValue() throws IOException {
        if ((this._numTypesValid & 8) == 0) {
            if (this._numTypesValid == 0) {
                this._checkNumericValue(8);
            }
            if ((this._numTypesValid & 8) == 0) {
                this.convertNumberToDouble();
            }
        }
        return this._numberDouble;
    }

    @Override
    public BigDecimal getDecimalValue() throws IOException {
        if ((this._numTypesValid & 0x10) == 0) {
            if (this._numTypesValid == 0) {
                this._checkNumericValue(16);
            }
            if ((this._numTypesValid & 0x10) == 0) {
                this.convertNumberToBigDecimal();
            }
        }
        return this._numberBigDecimal;
    }

    protected void _checkNumericValue(int expType) throws IOException {
        if (this._currToken == JsonToken.VALUE_NUMBER_INT || this._currToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return;
        }
        this._reportError("Current token (" + (Object)((Object)this._currToken) + ") not numeric, can not use numeric value accessors");
    }

    protected void convertNumberToInt() throws IOException {
        if ((this._numTypesValid & 2) != 0) {
            int result = (int)this._numberLong;
            if ((long)result != this._numberLong) {
                this._reportError("Numeric value (" + this.getText() + ") out of range of int");
            }
            this._numberInt = result;
        } else if ((this._numTypesValid & 4) != 0) {
            if (BI_MIN_INT.compareTo(this._numberBigInt) > 0 || BI_MAX_INT.compareTo(this._numberBigInt) < 0) {
                this.reportOverflowInt();
            }
            this._numberInt = this._numberBigInt.intValue();
        } else if ((this._numTypesValid & 8) != 0) {
            if (this._numberDouble < -2.147483648E9 || this._numberDouble > 2.147483647E9) {
                this.reportOverflowInt();
            }
            this._numberInt = (int)this._numberDouble;
        } else if ((this._numTypesValid & 0x10) != 0) {
            if (BD_MIN_INT.compareTo(this._numberBigDecimal) > 0 || BD_MAX_INT.compareTo(this._numberBigDecimal) < 0) {
                this.reportOverflowInt();
            }
            this._numberInt = this._numberBigDecimal.intValue();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 1;
    }

    protected void convertNumberToLong() throws IOException {
        if ((this._numTypesValid & 1) != 0) {
            this._numberLong = this._numberInt;
        } else if ((this._numTypesValid & 4) != 0) {
            if (BI_MIN_LONG.compareTo(this._numberBigInt) > 0 || BI_MAX_LONG.compareTo(this._numberBigInt) < 0) {
                this.reportOverflowLong();
            }
            this._numberLong = this._numberBigInt.longValue();
        } else if ((this._numTypesValid & 8) != 0) {
            if (this._numberDouble < -9.223372036854776E18 || this._numberDouble > 9.223372036854776E18) {
                this.reportOverflowLong();
            }
            this._numberLong = (long)this._numberDouble;
        } else if ((this._numTypesValid & 0x10) != 0) {
            if (BD_MIN_LONG.compareTo(this._numberBigDecimal) > 0 || BD_MAX_LONG.compareTo(this._numberBigDecimal) < 0) {
                this.reportOverflowLong();
            }
            this._numberLong = this._numberBigDecimal.longValue();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 2;
    }

    protected void convertNumberToBigInteger() throws IOException {
        if ((this._numTypesValid & 0x10) != 0) {
            this._numberBigInt = this._numberBigDecimal.toBigInteger();
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberBigInt = BigInteger.valueOf(this._numberLong);
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberBigInt = BigInteger.valueOf(this._numberInt);
        } else if ((this._numTypesValid & 8) != 0) {
            this._numberBigInt = BigDecimal.valueOf(this._numberDouble).toBigInteger();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 4;
    }

    protected void convertNumberToDouble() throws IOException {
        if ((this._numTypesValid & 0x10) != 0) {
            this._numberDouble = this._numberBigDecimal.doubleValue();
        } else if ((this._numTypesValid & 4) != 0) {
            this._numberDouble = this._numberBigInt.doubleValue();
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberDouble = this._numberLong;
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberDouble = this._numberInt;
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 8;
    }

    protected void convertNumberToBigDecimal() throws IOException {
        if ((this._numTypesValid & 8) != 0) {
            this._numberBigDecimal = NumberInput.parseBigDecimal(this.getText());
        } else if ((this._numTypesValid & 4) != 0) {
            this._numberBigDecimal = new BigDecimal(this._numberBigInt);
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberBigDecimal = BigDecimal.valueOf(this._numberLong);
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberBigDecimal = BigDecimal.valueOf(this._numberInt);
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 0x10;
    }

    protected void reportOverflowInt() throws IOException {
        this._reportError("Numeric value (" + this.getText() + ") out of range of int (" + Integer.MIN_VALUE + " - " + Integer.MAX_VALUE + ")");
    }

    protected void reportOverflowLong() throws IOException {
        this._reportError("Numeric value (" + this.getText() + ") out of range of long (" + Long.MIN_VALUE + " - " + Long.MAX_VALUE + ")");
    }

    protected void _finishToken() throws IOException {
        int len;
        this._tokenIncomplete = false;
        int ch = this._typeByte;
        int type = ch >> 5 & 7;
        ch &= 0x1F;
        if (type != 3) {
            if (type == 2) {
                this._finishBytes(this._decodeExplicitLength(ch));
                return;
            }
            this._throwInternal();
        }
        if ((len = this._decodeExplicitLength(ch)) <= 0) {
            if (len < 0) {
                this._finishChunkedText();
            } else {
                this._textBuffer.resetWithEmpty();
            }
            return;
        }
        if (len > this._inputEnd - this._inputPtr) {
            if (len >= this._inputBuffer.length) {
                this._finishLongText(len);
                return;
            }
            this._loadToHaveAtLeast(len);
        }
        this._finishShortText(len);
    }

    private final void _finishShortText(int len) throws IOException {
        int i;
        char[] outBuf = this._textBuffer.emptyAndGetCurrentSegment();
        if (outBuf.length < len) {
            outBuf = this._textBuffer.expandCurrentSegment(len);
        }
        int outPtr = 0;
        int inPtr = this._inputPtr;
        this._inputPtr += len;
        int[] codes = UTF8_UNIT_CODES;
        byte[] inputBuf = this._inputBuffer;
        int end = inPtr + len;
        while (codes[i = inputBuf[inPtr] & 0xFF] == 0) {
            outBuf[outPtr++] = (char)i;
            if (++inPtr != end) continue;
            this._textBuffer.setCurrentLength(outPtr);
            return;
        }
        do {
            i = inputBuf[inPtr++] & 0xFF;
            switch (codes[i]) {
                case 0: {
                    break;
                }
                case 1: {
                    i = (i & 0x1F) << 6 | inputBuf[inPtr++] & 0x3F;
                    break;
                }
                case 2: {
                    i = (i & 0xF) << 12 | (inputBuf[inPtr++] & 0x3F) << 6 | inputBuf[inPtr++] & 0x3F;
                    break;
                }
                case 3: {
                    i = (i & 7) << 18 | (inputBuf[inPtr++] & 0x3F) << 12 | (inputBuf[inPtr++] & 0x3F) << 6 | inputBuf[inPtr++] & 0x3F;
                    outBuf[outPtr++] = (char)(0xD800 | (i -= 65536) >> 10);
                    i = 0xDC00 | i & 0x3FF;
                    break;
                }
                default: {
                    this._reportError("Invalid byte " + Integer.toHexString(i) + " in Unicode text block");
                }
            }
            outBuf[outPtr++] = (char)i;
        } while (inPtr < end);
        this._textBuffer.setCurrentLength(outPtr);
    }

    private final void _finishLongText(int len) throws IOException {
        char[] outBuf = this._textBuffer.emptyAndGetCurrentSegment();
        int outPtr = 0;
        int[] codes = UTF8_UNIT_CODES;
        int outEnd = outBuf.length;
        while (--len >= 0) {
            int c = this._nextByte() & 0xFF;
            int code = codes[c];
            if (code == 0 && outPtr < outEnd) {
                outBuf[outPtr++] = (char)c;
                continue;
            }
            if ((len -= code) < 0) {
                throw this._constructError("Malformed UTF-8 character at end of long (non-chunked) text segment");
            }
            switch (code) {
                case 0: {
                    break;
                }
                case 1: {
                    int d = this._nextByte();
                    if ((d & 0xC0) != 128) {
                        this._reportInvalidOther(d & 0xFF, this._inputPtr);
                    }
                    c = (c & 0x1F) << 6 | d & 0x3F;
                    break;
                }
                case 2: {
                    c = this._decodeUTF8_3(c);
                    break;
                }
                case 3: {
                    c = this._decodeUTF8_4(c);
                    outBuf[outPtr++] = (char)(0xD800 | c >> 10);
                    if (outPtr >= outBuf.length) {
                        outBuf = this._textBuffer.finishCurrentSegment();
                        outPtr = 0;
                        outEnd = outBuf.length;
                    }
                    c = 0xDC00 | c & 0x3FF;
                    break;
                }
                default: {
                    this._reportInvalidChar(c);
                }
            }
            if (outPtr >= outEnd) {
                outBuf = this._textBuffer.finishCurrentSegment();
                outPtr = 0;
                outEnd = outBuf.length;
            }
            outBuf[outPtr++] = (char)c;
        }
        this._textBuffer.setCurrentLength(outPtr);
    }

    private final void _finishChunkedText() throws IOException {
        char[] outBuf = this._textBuffer.emptyAndGetCurrentSegment();
        int outPtr = 0;
        int[] codes = UTF8_UNIT_CODES;
        int outEnd = outBuf.length;
        byte[] input = this._inputBuffer;
        this._chunkEnd = this._inputPtr;
        this._chunkLeft = 0;
        while (true) {
            int c;
            int code;
            if (this._inputPtr >= this._chunkEnd) {
                if (this._chunkLeft == 0) {
                    int len = this._decodeChunkLength(3);
                    if (len < 0) break;
                    this._chunkLeft = len;
                    int end = this._inputPtr + len;
                    if (end <= this._inputEnd) {
                        this._chunkLeft = 0;
                        this._chunkEnd = end;
                    } else {
                        this._chunkLeft = end - this._inputEnd;
                        this._chunkEnd = this._inputEnd;
                    }
                }
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    int end = this._inputPtr + this._chunkLeft;
                    if (end <= this._inputEnd) {
                        this._chunkLeft = 0;
                        this._chunkEnd = end;
                    } else {
                        this._chunkLeft = end - this._inputEnd;
                        this._chunkEnd = this._inputEnd;
                    }
                }
            }
            if ((code = codes[c = input[this._inputPtr++] & 0xFF]) == 0 && outPtr < outEnd) {
                outBuf[outPtr++] = (char)c;
                continue;
            }
            switch (code) {
                case 0: {
                    break;
                }
                case 1: {
                    int d = this._nextChunkedByte();
                    if ((d & 0xC0) != 128) {
                        this._reportInvalidOther(d & 0xFF, this._inputPtr);
                    }
                    c = (c & 0x1F) << 6 | d & 0x3F;
                    break;
                }
                case 2: {
                    c = this._decodeChunkedUTF8_3(c);
                    break;
                }
                case 3: {
                    c = this._decodeChunkedUTF8_4(c);
                    outBuf[outPtr++] = (char)(0xD800 | c >> 10);
                    if (outPtr >= outBuf.length) {
                        outBuf = this._textBuffer.finishCurrentSegment();
                        outPtr = 0;
                        outEnd = outBuf.length;
                    }
                    c = 0xDC00 | c & 0x3FF;
                    break;
                }
                default: {
                    this._reportInvalidChar(c);
                }
            }
            if (outPtr >= outEnd) {
                outBuf = this._textBuffer.finishCurrentSegment();
                outPtr = 0;
                outEnd = outBuf.length;
            }
            outBuf[outPtr++] = (char)c;
        }
        this._textBuffer.setCurrentLength(outPtr);
    }

    private final int _nextByte() throws IOException {
        int inPtr = this._inputPtr;
        if (inPtr < this._inputEnd) {
            byte ch = this._inputBuffer[inPtr];
            this._inputPtr = inPtr + 1;
            return ch;
        }
        this.loadMoreGuaranteed();
        return this._inputBuffer[this._inputPtr++];
    }

    private final int _nextChunkedByte() throws IOException {
        int inPtr = this._inputPtr;
        if (inPtr >= this._chunkEnd) {
            return this._nextChunkedByte2();
        }
        byte ch = this._inputBuffer[inPtr];
        this._inputPtr = inPtr + 1;
        return ch;
    }

    private final int _nextChunkedByte2() throws IOException {
        int end;
        int len;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
            if (this._chunkLeft > 0) {
                int end2 = this._inputPtr + this._chunkLeft;
                if (end2 <= this._inputEnd) {
                    this._chunkLeft = 0;
                    this._chunkEnd = end2;
                } else {
                    this._chunkLeft = end2 - this._inputEnd;
                    this._chunkEnd = this._inputEnd;
                }
                return this._inputBuffer[this._inputPtr++];
            }
        }
        if ((len = this._decodeChunkLength(3)) < 0) {
            this._reportInvalidEOF(": chunked Text ends with partial UTF-8 character");
        }
        if ((end = this._inputPtr + len) <= this._inputEnd) {
            this._chunkLeft = 0;
            this._chunkEnd = end;
        } else {
            this._chunkLeft = end - this._inputEnd;
            this._chunkEnd = this._inputEnd;
        }
        return this._inputBuffer[this._inputPtr++];
    }

    protected void _finishBytes(int len) throws IOException {
        if (len >= 0) {
            this._binaryValue = new byte[len];
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            int ptr = 0;
            while (true) {
                int toAdd = Math.min(len, this._inputEnd - this._inputPtr);
                System.arraycopy(this._inputBuffer, this._inputPtr, this._binaryValue, ptr, toAdd);
                this._inputPtr += toAdd;
                ptr += toAdd;
                if ((len -= toAdd) <= 0) {
                    return;
                }
                this.loadMoreGuaranteed();
            }
        }
        ByteArrayBuilder bb = this._getByteArrayBuilder();
        block1: while (true) {
            int ch;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((ch = this._inputBuffer[this._inputPtr++] & 0xFF) == 255) break;
            int type = ch >> 5;
            if (type != 2) {
                throw this._constructError("Mismatched chunk in chunked content: expected 2 but encountered " + type);
            }
            len = this._decodeExplicitLength(ch & 0x1F);
            if (len < 0) {
                throw this._constructError("Illegal chunked-length indicator within chunked-length value (type 2)");
            }
            while (true) {
                if (len <= 0) continue block1;
                int avail = this._inputEnd - this._inputPtr;
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    avail = this._inputEnd - this._inputPtr;
                }
                int count = Math.min(avail, len);
                bb.write(this._inputBuffer, this._inputPtr, count);
                this._inputPtr += count;
                len -= count;
            }
            break;
        }
        this._binaryValue = bb.toByteArray();
    }

    protected final JsonToken _decodeFieldName() throws IOException {
        String name;
        byte ch;
        int type;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((type = (ch = this._inputBuffer[this._inputPtr++]) >> 5 & 7) != 3) {
            if (ch == -1) {
                if (!this._parsingContext.hasExpectedLength()) {
                    this._parsingContext = this._parsingContext.getParent();
                    return JsonToken.END_OBJECT;
                }
                this._reportUnexpectedBreak();
            }
            this._decodeNonStringName(ch);
            return JsonToken.FIELD_NAME;
        }
        int lenMarker = ch & 0x1F;
        if (lenMarker <= 23) {
            if (lenMarker == 0) {
                name = "";
            } else {
                Name n = this._findDecodedFromSymbols(lenMarker);
                if (n != null) {
                    name = n.getName();
                    this._inputPtr += lenMarker;
                } else {
                    name = this._decodeShortName(lenMarker);
                    name = this._addDecodedToSymbols(lenMarker, name);
                }
            }
        } else {
            int actualLen = this._decodeExplicitLength(lenMarker);
            name = actualLen < 0 ? this._decodeChunkedName() : this._decodeLongerName(actualLen);
        }
        this._parsingContext.setCurrentName(name);
        return JsonToken.FIELD_NAME;
    }

    private final String _decodeShortName(int len) throws IOException {
        int i;
        int code;
        int outPtr = 0;
        char[] outBuf = this._textBuffer.emptyAndGetCurrentSegment();
        if (outBuf.length < len) {
            outBuf = this._textBuffer.expandCurrentSegment(len);
        }
        int inPtr = this._inputPtr;
        this._inputPtr += len;
        int[] codes = UTF8_UNIT_CODES;
        byte[] inBuf = this._inputBuffer;
        int end = inPtr + len;
        while ((code = codes[i = inBuf[inPtr] & 0xFF]) == 0) {
            outBuf[outPtr++] = (char)i;
            if (++inPtr != end) continue;
            this._textBuffer.setCurrentLength(outPtr);
            return this._textBuffer.contentsAsString();
        }
        while (inPtr < end) {
            if ((code = codes[i = inBuf[inPtr++] & 0xFF]) != 0) {
                switch (code) {
                    case 1: {
                        i = (i & 0x1F) << 6 | inBuf[inPtr++] & 0x3F;
                        break;
                    }
                    case 2: {
                        i = (i & 0xF) << 12 | (inBuf[inPtr++] & 0x3F) << 6 | inBuf[inPtr++] & 0x3F;
                        break;
                    }
                    case 3: {
                        i = (i & 7) << 18 | (inBuf[inPtr++] & 0x3F) << 12 | (inBuf[inPtr++] & 0x3F) << 6 | inBuf[inPtr++] & 0x3F;
                        outBuf[outPtr++] = (char)(0xD800 | (i -= 65536) >> 10);
                        i = 0xDC00 | i & 0x3FF;
                        break;
                    }
                    default: {
                        this._reportError("Invalid byte " + Integer.toHexString(i) + " in Object name");
                    }
                }
            }
            outBuf[outPtr++] = (char)i;
        }
        this._textBuffer.setCurrentLength(outPtr);
        return this._textBuffer.contentsAsString();
    }

    private final String _decodeLongerName(int len) throws IOException {
        Name n;
        if (this._inputEnd - this._inputPtr < len) {
            if (len >= this._inputBuffer.length) {
                this._finishLongText(len);
                return this._textBuffer.contentsAsString();
            }
            this._loadToHaveAtLeast(len);
        }
        if ((n = this._findDecodedFromSymbols(len)) != null) {
            this._inputPtr += len;
            return n.getName();
        }
        String name = this._decodeShortName(len);
        return this._addDecodedToSymbols(len, name);
    }

    private final String _decodeChunkedName() throws IOException {
        this._finishChunkedText();
        return this._textBuffer.contentsAsString();
    }

    protected final void _decodeNonStringName(int ch) throws IOException {
        String name;
        int type = ch >> 5 & 7;
        if (type == 0) {
            name = this._numberToName(ch, false);
        } else if (type == 1) {
            name = this._numberToName(ch, true);
        } else {
            if ((ch & 0xFF) == 255) {
                this._reportUnexpectedBreak();
            }
            throw this._constructError("Unsupported major type (" + type + ") for CBOR Objects, not (yet?) supported, only Strings");
        }
        this._parsingContext.setCurrentName(name);
    }

    private final Name _findDecodedFromSymbols(int len) throws IOException {
        if (this._inputEnd - this._inputPtr < len) {
            this._loadToHaveAtLeast(len);
        }
        if (len < 5) {
            int inPtr = this._inputPtr;
            byte[] inBuf = this._inputBuffer;
            int q = inBuf[inPtr] & 0xFF;
            if (--len > 0) {
                q = (q << 8) + (inBuf[++inPtr] & 0xFF);
                if (--len > 0) {
                    q = (q << 8) + (inBuf[++inPtr] & 0xFF);
                    if (--len > 0) {
                        q = (q << 8) + (inBuf[++inPtr] & 0xFF);
                    }
                }
            }
            this._quad1 = q;
            return this._symbols.findName(q);
        }
        if (len < 9) {
            int inPtr = this._inputPtr;
            byte[] inBuf = this._inputBuffer;
            int q1 = (inBuf[inPtr] & 0xFF) << 8;
            q1 += inBuf[++inPtr] & 0xFF;
            q1 <<= 8;
            q1 += inBuf[++inPtr] & 0xFF;
            q1 <<= 8;
            q1 += inBuf[++inPtr] & 0xFF;
            int q2 = inBuf[++inPtr] & 0xFF;
            if ((len -= 5) > 0) {
                q2 = (q2 << 8) + (inBuf[++inPtr] & 0xFF);
                if (--len > 0) {
                    q2 = (q2 << 8) + (inBuf[++inPtr] & 0xFF);
                    if (--len > 0) {
                        q2 = (q2 << 8) + (inBuf[++inPtr] & 0xFF);
                    }
                }
            }
            this._quad1 = q1;
            this._quad2 = q2;
            return this._symbols.findName(q1, q2);
        }
        return this._findDecodedMedium(len);
    }

    private final Name _findDecodedMedium(int len) throws IOException {
        int q;
        int bufLen = len + 3 >> 2;
        if (bufLen > this._quadBuffer.length) {
            this._quadBuffer = CBORParser._growArrayTo(this._quadBuffer, bufLen);
        }
        int offset = 0;
        int inPtr = this._inputPtr;
        byte[] inBuf = this._inputBuffer;
        do {
            q = (inBuf[inPtr++] & 0xFF) << 8;
            q |= inBuf[inPtr++] & 0xFF;
            q <<= 8;
            q |= inBuf[inPtr++] & 0xFF;
            q <<= 8;
            this._quadBuffer[offset++] = q |= inBuf[inPtr++] & 0xFF;
        } while ((len -= 4) > 3);
        if (len > 0) {
            q = inBuf[inPtr] & 0xFF;
            if (--len > 0) {
                q = (q << 8) + (inBuf[++inPtr] & 0xFF);
                if (--len > 0) {
                    q = (q << 8) + (inBuf[++inPtr] & 0xFF);
                }
            }
            this._quadBuffer[offset++] = q;
        }
        return this._symbols.findName(this._quadBuffer, offset);
    }

    private final String _addDecodedToSymbols(int len, String name) {
        if (len < 5) {
            return this._symbols.addName(name, this._quad1, 0).getName();
        }
        if (len < 9) {
            return this._symbols.addName(name, this._quad1, this._quad2).getName();
        }
        int qlen = len + 3 >> 2;
        return this._symbols.addName(name, this._quadBuffer, qlen).getName();
    }

    private static int[] _growArrayTo(int[] arr, int minSize) {
        return Arrays.copyOf(arr, minSize + 4);
    }

    protected void _skipIncomplete() throws IOException {
        int lowBits;
        this._tokenIncomplete = false;
        int type = this._typeByte >> 5 & 7;
        if (type != 3 && type == 3) {
            this._throwInternal();
        }
        if ((lowBits = this._typeByte & 0x1F) <= 23) {
            if (lowBits > 0) {
                this._skipBytes(lowBits);
            }
            return;
        }
        switch (lowBits) {
            case 24: {
                this._skipBytes(this._decode8Bits());
                break;
            }
            case 25: {
                this._skipBytes(this._decode16Bits());
                break;
            }
            case 26: {
                this._skipBytes(this._decode32Bits());
                break;
            }
            case 27: {
                this._skipBytesL(this._decode64Bits());
                break;
            }
            case 31: {
                this._skipChunked(type);
                break;
            }
            default: {
                this._invalidToken(this._typeByte);
            }
        }
    }

    protected void _skipChunked(int expectedType) throws IOException {
        block7: while (true) {
            int ch;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((ch = this._inputBuffer[this._inputPtr++] & 0xFF) == 255) {
                return;
            }
            int type = ch >> 5;
            if (type != expectedType) {
                throw this._constructError("Mismatched chunk in chunked content: expected " + expectedType + " but encountered " + type);
            }
            int lowBits = ch & 0x1F;
            if (lowBits <= 23) {
                if (lowBits <= 0) continue;
                this._skipBytes(lowBits);
                continue;
            }
            switch (lowBits) {
                case 24: {
                    this._skipBytes(this._decode8Bits());
                    continue block7;
                }
                case 25: {
                    this._skipBytes(this._decode16Bits());
                    continue block7;
                }
                case 26: {
                    this._skipBytes(this._decode32Bits());
                    continue block7;
                }
                case 27: {
                    this._skipBytesL(this._decode64Bits());
                    continue block7;
                }
                case 31: {
                    throw this._constructError("Illegal chunked-length indicator within chunked-length value (type " + expectedType + ")");
                }
            }
            this._invalidToken(this._typeByte);
        }
    }

    protected void _skipBytesL(long llen) throws IOException {
        while (llen > Integer.MAX_VALUE) {
            this._skipBytes(Integer.MAX_VALUE);
            llen -= Integer.MAX_VALUE;
        }
        this._skipBytes((int)llen);
    }

    protected void _skipBytes(int len) throws IOException {
        while (true) {
            int toAdd = Math.min(len, this._inputEnd - this._inputPtr);
            this._inputPtr += toAdd;
            if ((len -= toAdd) <= 0) {
                return;
            }
            this.loadMoreGuaranteed();
        }
    }

    private final int _decodeTag(int lowBits) throws IOException {
        if (lowBits <= 23) {
            return lowBits;
        }
        switch (lowBits - 24) {
            case 0: {
                return this._decode8Bits();
            }
            case 1: {
                return this._decode16Bits();
            }
            case 2: {
                return this._decode32Bits();
            }
            case 3: {
                long l = this._decode64Bits();
                if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                    this._reportError("Illegal Tag value: " + l);
                }
                return (int)l;
            }
        }
        throw this._constructError("Invalid low bits for Tag token: 0x" + Integer.toHexString(lowBits));
    }

    private final int _decodeExplicitLength(int lowBits) throws IOException {
        if (lowBits == 31) {
            return -1;
        }
        if (lowBits <= 23) {
            return lowBits;
        }
        switch (lowBits - 24) {
            case 0: {
                return this._decode8Bits();
            }
            case 1: {
                return this._decode16Bits();
            }
            case 2: {
                return this._decode32Bits();
            }
            case 3: {
                long l = this._decode64Bits();
                if (l < 0L || l > Integer.MAX_VALUE) {
                    throw this._constructError("Illegal length for " + (Object)((Object)this._currToken) + ": " + l);
                }
                return (int)l;
            }
        }
        throw this._constructError("Invalid length for " + (Object)((Object)this._currToken) + ": 0x" + Integer.toHexString(lowBits));
    }

    private int _decodeChunkLength(int expType) throws IOException {
        int ch;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((ch = this._inputBuffer[this._inputPtr++] & 0xFF) == 255) {
            return -1;
        }
        int type = ch >> 5;
        if (type != expType) {
            throw this._constructError("Mismatched chunk in chunked content: expected " + expType + " but encountered " + type + " (byte 0x" + Integer.toHexString(ch) + ")");
        }
        int len = this._decodeExplicitLength(ch & 0x1F);
        if (len < 0) {
            throw this._constructError("Illegal chunked-length indicator within chunked-length value (type " + expType + ")");
        }
        return len;
    }

    private double _decodeHalfSizeFloat() throws IOException {
        int i16 = this._decode16Bits() & 0xFFFF;
        boolean neg = i16 >> 15 != 0;
        int e = i16 >> 10 & 0x1F;
        int f = i16 & 0x3FF;
        if (e == 0) {
            double d = MATH_POW_2_NEG14 * ((double)f / MATH_POW_2_10);
            return neg ? -d : d;
        }
        if (e == 31) {
            if (f != 0) {
                return Double.NaN;
            }
            return neg ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        double d = Math.pow(2.0, e - 15) * (1.0 + (double)f / MATH_POW_2_10);
        return neg ? -d : d;
    }

    private final int _decode8Bits() throws IOException {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        return this._inputBuffer[this._inputPtr++] & 0xFF;
    }

    private final int _decode16Bits() throws IOException {
        int ptr = this._inputPtr;
        if (ptr + 1 >= this._inputEnd) {
            return this._slow16();
        }
        byte[] b = this._inputBuffer;
        int v = ((b[ptr] & 0xFF) << 8) + (b[ptr + 1] & 0xFF);
        this._inputPtr = ptr + 2;
        return v;
    }

    private final int _slow16() throws IOException {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        int v = this._inputBuffer[this._inputPtr++] & 0xFF;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        return (v << 8) + (this._inputBuffer[this._inputPtr++] & 0xFF);
    }

    private final int _decode32Bits() throws IOException {
        int ptr = this._inputPtr;
        if (ptr + 3 >= this._inputEnd) {
            return this._slow32();
        }
        byte[] b = this._inputBuffer;
        int v = (b[ptr++] << 24) + ((b[ptr++] & 0xFF) << 16) + ((b[ptr++] & 0xFF) << 8) + (b[ptr++] & 0xFF);
        this._inputPtr = ptr;
        return v;
    }

    private final int _slow32() throws IOException {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        int v = this._inputBuffer[this._inputPtr++];
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        v = (v << 8) + (this._inputBuffer[this._inputPtr++] & 0xFF);
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        v = (v << 8) + (this._inputBuffer[this._inputPtr++] & 0xFF);
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        return (v << 8) + (this._inputBuffer[this._inputPtr++] & 0xFF);
    }

    private final long _decode64Bits() throws IOException {
        int ptr = this._inputPtr;
        if (ptr + 7 >= this._inputEnd) {
            return this._slow64();
        }
        byte[] b = this._inputBuffer;
        int i1 = (b[ptr++] << 24) + ((b[ptr++] & 0xFF) << 16) + ((b[ptr++] & 0xFF) << 8) + (b[ptr++] & 0xFF);
        int i2 = (b[ptr++] << 24) + ((b[ptr++] & 0xFF) << 16) + ((b[ptr++] & 0xFF) << 8) + (b[ptr++] & 0xFF);
        this._inputPtr = ptr;
        return CBORParser._long(i1, i2);
    }

    private final long _slow64() throws IOException {
        return CBORParser._long(this._decode32Bits(), this._decode32Bits());
    }

    private static final long _long(int i1, int i2) {
        long l1 = i1;
        long l2 = i2;
        l2 = l2 << 32 >>> 32;
        return (l1 << 32) + l2;
    }

    private final int _decodeUTF8_3(int c1) throws IOException {
        c1 &= 0xF;
        int d = this._nextByte();
        if ((d & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        int c = c1 << 6 | d & 0x3F;
        d = this._nextByte();
        if ((d & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        c = c << 6 | d & 0x3F;
        return c;
    }

    private final int _decodeChunkedUTF8_3(int c1) throws IOException {
        c1 &= 0xF;
        int d = this._nextChunkedByte();
        if ((d & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        int c = c1 << 6 | d & 0x3F;
        d = this._nextChunkedByte();
        if ((d & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        c = c << 6 | d & 0x3F;
        return c;
    }

    private final int _decodeUTF8_4(int c) throws IOException {
        int d = this._nextByte();
        if ((d & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        c = (c & 7) << 6 | d & 0x3F;
        d = this._nextByte();
        if ((d & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        c = c << 6 | d & 0x3F;
        d = this._nextByte();
        if ((d & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        return (c << 6 | d & 0x3F) - 65536;
    }

    private final int _decodeChunkedUTF8_4(int c) throws IOException {
        int d = this._nextChunkedByte();
        if ((d & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        c = (c & 7) << 6 | d & 0x3F;
        d = this._nextChunkedByte();
        if ((d & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        c = c << 6 | d & 0x3F;
        d = this._nextChunkedByte();
        if ((d & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        return (c << 6 | d & 0x3F) - 65536;
    }

    protected final boolean loadMore() throws IOException {
        this._currInputProcessed += (long)this._inputEnd;
        if (this._inputStream != null) {
            int count = this._inputStream.read(this._inputBuffer, 0, this._inputBuffer.length);
            if (count > 0) {
                this._inputPtr = 0;
                this._inputEnd = count;
                return true;
            }
            this._closeInput();
            if (count == 0) {
                throw new IOException("InputStream.read() returned 0 characters when trying to read " + this._inputBuffer.length + " bytes");
            }
        }
        return false;
    }

    protected final void loadMoreGuaranteed() throws IOException {
        if (!this.loadMore()) {
            this._reportInvalidEOF();
        }
    }

    protected final void _loadToHaveAtLeast(int minAvailable) throws IOException {
        if (this._inputStream == null) {
            throw this._constructError("Needed to read " + minAvailable + " bytes, reached end-of-input");
        }
        int amount = this._inputEnd - this._inputPtr;
        if (amount > 0 && this._inputPtr > 0) {
            this._currInputProcessed += (long)this._inputPtr;
            System.arraycopy(this._inputBuffer, this._inputPtr, this._inputBuffer, 0, amount);
            this._inputEnd = amount;
        } else {
            this._inputEnd = 0;
        }
        this._inputPtr = 0;
        while (this._inputEnd < minAvailable) {
            int count = this._inputStream.read(this._inputBuffer, this._inputEnd, this._inputBuffer.length - this._inputEnd);
            if (count < 1) {
                this._closeInput();
                if (count == 0) {
                    throw new IOException("InputStream.read() returned 0 characters when trying to read " + amount + " bytes");
                }
                throw this._constructError("Needed to read " + minAvailable + " bytes, missed " + minAvailable + " before end-of-input");
            }
            this._inputEnd += count;
        }
    }

    protected ByteArrayBuilder _getByteArrayBuilder() {
        if (this._byteArrayBuilder == null) {
            this._byteArrayBuilder = new ByteArrayBuilder();
        } else {
            this._byteArrayBuilder.reset();
        }
        return this._byteArrayBuilder;
    }

    protected void _closeInput() throws IOException {
        if (this._inputStream != null) {
            if (this._ioContext.isResourceManaged() || this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE)) {
                this._inputStream.close();
            }
            this._inputStream = null;
        }
    }

    @Override
    protected void _handleEOF() throws JsonParseException {
        if (!this._parsingContext.inRoot()) {
            this._reportInvalidEOF(": expected close marker for " + this._parsingContext.getTypeDesc() + " (from " + this._parsingContext.getStartLocation(this._ioContext.getSourceReference()) + ")");
        }
    }

    protected void _reportUnexpectedBreak() throws IOException {
        if (this._parsingContext.inRoot()) {
            throw this._constructError("Unexpected Break (0xFF) token in Root context");
        }
        throw this._constructError("Unexpected Break (0xFF) token in definite length (" + this._parsingContext.getExpectedLength() + ") " + (this._parsingContext.inObject() ? "Object" : "Array"));
    }

    protected void _reportInvalidChar(int c) throws JsonParseException {
        if (c < 32) {
            this._throwInvalidSpace(c);
        }
        this._reportInvalidInitial(c);
    }

    protected void _reportInvalidInitial(int mask) throws JsonParseException {
        this._reportError("Invalid UTF-8 start byte 0x" + Integer.toHexString(mask));
    }

    protected void _reportInvalidOther(int mask) throws JsonParseException {
        this._reportError("Invalid UTF-8 middle byte 0x" + Integer.toHexString(mask));
    }

    protected void _reportInvalidOther(int mask, int ptr) throws JsonParseException {
        this._inputPtr = ptr;
        this._reportInvalidOther(mask);
    }

    public static enum Feature {
        BOGUS(false);

        final boolean _defaultState;
        final int _mask;

        public static int collectDefaults() {
            int flags = 0;
            for (Feature f : Feature.values()) {
                if (!f.enabledByDefault()) continue;
                flags |= f.getMask();
            }
            return flags;
        }

        private Feature(boolean defaultState) {
            this._defaultState = defaultState;
            this._mask = 1 << this.ordinal();
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public int getMask() {
            return this._mask;
        }
    }
}

