/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.CopyOnWriteHashMap;
import org.elasticsearch.common.collect.CopyOnWriteHashSet;
import org.elasticsearch.common.collect.ForwardingSet;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldMappers;

public class FieldMappersLookup
extends ForwardingSet<FieldMapper<?>> {
    private final CopyOnWriteHashSet<FieldMapper<?>> mappers;
    private final MappersLookup lookup;

    private static CopyOnWriteHashMap<String, FieldMappers> add(CopyOnWriteHashMap<String, FieldMappers> map, String key, FieldMapper<?> mapper) {
        FieldMappers mappers = map.get(key);
        mappers = mappers == null ? new FieldMappers(mapper) : mappers.concat(mapper);
        return map.copyAndPut(key, mappers);
    }

    private static CopyOnWriteHashMap<String, FieldMappers> remove(CopyOnWriteHashMap<String, FieldMappers> map, String key, FieldMapper<?> mapper) {
        FieldMappers mappers = map.get(key);
        if (mappers == null) {
            return map;
        }
        if ((mappers = mappers.remove(mapper)).isEmpty()) {
            return map.copyAndRemove(key);
        }
        return map.copyAndPut(key, mappers);
    }

    public FieldMappersLookup() {
        this(new CopyOnWriteHashSet(), new MappersLookup(new CopyOnWriteHashMap<String, FieldMappers>(), new CopyOnWriteHashMap<String, FieldMappers>(), new CopyOnWriteHashMap<String, FieldMappers>()));
    }

    private FieldMappersLookup(CopyOnWriteHashSet<FieldMapper<?>> mappers, MappersLookup lookup) {
        this.mappers = mappers;
        this.lookup = lookup;
    }

    public FieldMappersLookup copyAndAddAll(Collection<? extends FieldMapper<?>> newMappers) {
        return new FieldMappersLookup(this.mappers.copyAndAddAll(newMappers), this.lookup.addNewMappers(newMappers));
    }

    public FieldMappersLookup copyAndRemoveAll(Collection<?> mappersToRemove) {
        CopyOnWriteHashSet<FieldMapper<?>> newMappers = this.mappers.copyAndRemoveAll(mappersToRemove);
        if (newMappers != this.mappers) {
            return new FieldMappersLookup(newMappers, this.lookup.removeMappers(mappersToRemove));
        }
        return this;
    }

    public FieldMappers name(String name) {
        return this.lookup.name.get(name);
    }

    public FieldMappers indexName(String indexName) {
        return this.lookup.indexName.get(indexName);
    }

    public FieldMappers fullName(String fullName) {
        return this.lookup.fullName.get(fullName);
    }

    public List<String> simpleMatchToIndexNames(String pattern) {
        ArrayList<String> fields = Lists.newArrayList();
        for (FieldMapper fieldMapper : this.mappers) {
            if (Regex.simpleMatch(pattern, fieldMapper.names().fullName())) {
                fields.add(fieldMapper.names().indexName());
                continue;
            }
            if (Regex.simpleMatch(pattern, fieldMapper.names().indexName())) {
                fields.add(fieldMapper.names().indexName());
                continue;
            }
            if (!Regex.simpleMatch(pattern, fieldMapper.names().name())) continue;
            fields.add(fieldMapper.names().indexName());
        }
        return fields;
    }

    public List<String> simpleMatchToFullName(String pattern) {
        ArrayList<String> fields = Lists.newArrayList();
        for (FieldMapper fieldMapper : this.mappers) {
            if (Regex.simpleMatch(pattern, fieldMapper.names().fullName())) {
                fields.add(fieldMapper.names().fullName());
                continue;
            }
            if (Regex.simpleMatch(pattern, fieldMapper.names().indexName())) {
                fields.add(fieldMapper.names().fullName());
                continue;
            }
            if (!Regex.simpleMatch(pattern, fieldMapper.names().name())) continue;
            fields.add(fieldMapper.names().fullName());
        }
        return fields;
    }

    @Nullable
    public FieldMappers smartName(String name) {
        FieldMappers fieldMappers = this.fullName(name);
        if (fieldMappers != null) {
            return fieldMappers;
        }
        fieldMappers = this.indexName(name);
        if (fieldMappers != null) {
            return fieldMappers;
        }
        return this.name(name);
    }

    @Nullable
    public FieldMapper<?> smartNameFieldMapper(String name) {
        FieldMappers fieldMappers = this.smartName(name);
        if (fieldMappers == null) {
            return null;
        }
        return fieldMappers.mapper();
    }

    @Override
    protected Set<FieldMapper<?>> delegate() {
        return this.mappers;
    }

    private static class MappersLookup {
        final CopyOnWriteHashMap<String, FieldMappers> name;
        final CopyOnWriteHashMap<String, FieldMappers> indexName;
        final CopyOnWriteHashMap<String, FieldMappers> fullName;

        MappersLookup(CopyOnWriteHashMap<String, FieldMappers> name, CopyOnWriteHashMap<String, FieldMappers> indexName, CopyOnWriteHashMap<String, FieldMappers> fullName) {
            this.name = name;
            this.indexName = indexName;
            this.fullName = fullName;
        }

        MappersLookup addNewMappers(Iterable<? extends FieldMapper<?>> mappers) {
            CopyOnWriteHashMap name = this.name;
            CopyOnWriteHashMap indexName = this.indexName;
            CopyOnWriteHashMap fullName = this.fullName;
            for (FieldMapper<?> mapper : mappers) {
                name = FieldMappersLookup.add(name, mapper.names().name(), mapper);
                indexName = FieldMappersLookup.add(indexName, mapper.names().indexName(), mapper);
                fullName = FieldMappersLookup.add(fullName, mapper.names().fullName(), mapper);
            }
            return new MappersLookup(name, indexName, fullName);
        }

        MappersLookup removeMappers(Iterable<?> mappers) {
            CopyOnWriteHashMap name = this.name;
            CopyOnWriteHashMap indexName = this.indexName;
            CopyOnWriteHashMap fullName = this.fullName;
            for (Object o : mappers) {
                if (!(o instanceof FieldMapper)) continue;
                FieldMapper mapper = (FieldMapper)o;
                name = FieldMappersLookup.remove(name, mapper.names().name(), mapper);
                indexName = FieldMappersLookup.remove(indexName, mapper.names().indexName(), mapper);
                fullName = FieldMappersLookup.remove(fullName, mapper.names().fullName(), mapper);
            }
            return new MappersLookup(name, indexName, fullName);
        }
    }
}

