/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.merge.scheduler;

import java.io.Closeable;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.merge.EnableMergeScheduler;
import org.elasticsearch.index.merge.MergeStats;
import org.elasticsearch.index.merge.OnGoingMerge;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.threadpool.ThreadPool;

public abstract class MergeSchedulerProvider
extends AbstractIndexShardComponent
implements Closeable {
    public static final String FORCE_ASYNC_MERGE = "index.merge.force_async_merge";
    private final ThreadPool threadPool;
    private final CopyOnWriteArrayList<FailureListener> failureListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<Listener> listeners = new CopyOnWriteArrayList();
    private final boolean notifyOnMergeFailure;

    protected MergeSchedulerProvider(ShardId shardId, @IndexSettings Settings indexSettings, ThreadPool threadPool) {
        super(shardId, indexSettings);
        this.threadPool = threadPool;
        this.notifyOnMergeFailure = this.componentSettings.getAsBoolean("notify_on_failure", (Boolean)true);
    }

    public void addFailureListener(FailureListener listener) {
        this.failureListeners.add(listener);
    }

    public void removeFailureListener(FailureListener listener) {
        this.failureListeners.remove(listener);
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    protected void failedMerge(final MergePolicy.MergeException e) {
        if (!this.notifyOnMergeFailure) {
            return;
        }
        for (final FailureListener failureListener : this.failureListeners) {
            this.threadPool.generic().execute(new Runnable(){

                @Override
                public void run() {
                    failureListener.onFailedMerge(e);
                }
            });
        }
    }

    protected void beforeMerge(OnGoingMerge merge) {
        for (Listener listener : this.listeners) {
            listener.beforeMerge(merge);
        }
    }

    protected void afterMerge(OnGoingMerge merge) {
        for (Listener listener : this.listeners) {
            listener.afterMerge(merge);
        }
    }

    public final MergeScheduler newMergeScheduler() {
        MergeScheduler scheduler = this.buildMergeScheduler();
        if (this.indexSettings.getAsBoolean(FORCE_ASYNC_MERGE, (Boolean)true).booleanValue()) {
            scheduler = new EnableMergeScheduler(scheduler);
        }
        return scheduler;
    }

    public abstract int getMaxMerges();

    protected abstract MergeScheduler buildMergeScheduler();

    public abstract MergeStats stats();

    public abstract Set<OnGoingMerge> onGoingMerges();

    @Override
    public abstract void close();

    public static interface Listener {
        public void beforeMerge(OnGoingMerge var1);

        public void afterMerge(OnGoingMerge var1);
    }

    public static interface FailureListener {
        public void onFailedMerge(MergePolicy.MergeException var1);
    }
}

