/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseFilterBuilder;

public class RangeFilterBuilder
extends BaseFilterBuilder {
    private final String name;
    private Object from;
    private Object to;
    private String timeZone;
    private boolean includeLower = true;
    private boolean includeUpper = true;
    private Boolean cache;
    private String cacheKey;
    private String filterName;
    private String execution;

    public RangeFilterBuilder(String name) {
        this.name = name;
    }

    public RangeFilterBuilder from(Object from) {
        this.from = from;
        return this;
    }

    public RangeFilterBuilder from(int from) {
        this.from = from;
        return this;
    }

    public RangeFilterBuilder from(long from) {
        this.from = from;
        return this;
    }

    public RangeFilterBuilder from(float from) {
        this.from = Float.valueOf(from);
        return this;
    }

    public RangeFilterBuilder from(double from) {
        this.from = from;
        return this;
    }

    public RangeFilterBuilder gt(Object from) {
        this.from = from;
        this.includeLower = false;
        return this;
    }

    public RangeFilterBuilder gt(int from) {
        this.from = from;
        this.includeLower = false;
        return this;
    }

    public RangeFilterBuilder gt(long from) {
        this.from = from;
        this.includeLower = false;
        return this;
    }

    public RangeFilterBuilder gt(float from) {
        this.from = Float.valueOf(from);
        this.includeLower = false;
        return this;
    }

    public RangeFilterBuilder gt(double from) {
        this.from = from;
        this.includeLower = false;
        return this;
    }

    public RangeFilterBuilder gte(Object from) {
        this.from = from;
        this.includeLower = true;
        return this;
    }

    public RangeFilterBuilder gte(int from) {
        this.from = from;
        this.includeLower = true;
        return this;
    }

    public RangeFilterBuilder gte(long from) {
        this.from = from;
        this.includeLower = true;
        return this;
    }

    public RangeFilterBuilder gte(float from) {
        this.from = Float.valueOf(from);
        this.includeLower = true;
        return this;
    }

    public RangeFilterBuilder gte(double from) {
        this.from = from;
        this.includeLower = true;
        return this;
    }

    public RangeFilterBuilder to(Object to) {
        this.to = to;
        return this;
    }

    public RangeFilterBuilder to(int to) {
        this.to = to;
        return this;
    }

    public RangeFilterBuilder to(long to) {
        this.to = to;
        return this;
    }

    public RangeFilterBuilder to(float to) {
        this.to = Float.valueOf(to);
        return this;
    }

    public RangeFilterBuilder to(double to) {
        this.to = to;
        return this;
    }

    public RangeFilterBuilder lt(Object to) {
        this.to = to;
        this.includeUpper = false;
        return this;
    }

    public RangeFilterBuilder lt(int to) {
        this.to = to;
        this.includeUpper = false;
        return this;
    }

    public RangeFilterBuilder lt(long to) {
        this.to = to;
        this.includeUpper = false;
        return this;
    }

    public RangeFilterBuilder lt(float to) {
        this.to = Float.valueOf(to);
        this.includeUpper = false;
        return this;
    }

    public RangeFilterBuilder lt(double to) {
        this.to = to;
        this.includeUpper = false;
        return this;
    }

    public RangeFilterBuilder lte(int to) {
        this.to = to;
        this.includeUpper = true;
        return this;
    }

    public RangeFilterBuilder lte(long to) {
        this.to = to;
        this.includeUpper = true;
        return this;
    }

    public RangeFilterBuilder lte(float to) {
        this.to = Float.valueOf(to);
        this.includeUpper = true;
        return this;
    }

    public RangeFilterBuilder lte(double to) {
        this.to = to;
        this.includeUpper = true;
        return this;
    }

    public RangeFilterBuilder lte(Object to) {
        this.to = to;
        this.includeUpper = true;
        return this;
    }

    public RangeFilterBuilder includeLower(boolean includeLower) {
        this.includeLower = includeLower;
        return this;
    }

    public RangeFilterBuilder includeUpper(boolean includeUpper) {
        this.includeUpper = includeUpper;
        return this;
    }

    public RangeFilterBuilder filterName(String filterName) {
        this.filterName = filterName;
        return this;
    }

    public RangeFilterBuilder cache(boolean cache) {
        this.cache = cache;
        return this;
    }

    public RangeFilterBuilder cacheKey(String cacheKey) {
        this.cacheKey = cacheKey;
        return this;
    }

    public RangeFilterBuilder setExecution(String execution) {
        this.execution = execution;
        return this;
    }

    public RangeFilterBuilder timeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("range");
        builder.startObject(this.name);
        builder.field("from", this.from);
        builder.field("to", this.to);
        if (this.timeZone != null) {
            builder.field("time_zone", this.timeZone);
        }
        builder.field("include_lower", this.includeLower);
        builder.field("include_upper", this.includeUpper);
        builder.endObject();
        if (this.filterName != null) {
            builder.field("_name", this.filterName);
        }
        if (this.cache != null) {
            builder.field("_cache", (Object)this.cache);
        }
        if (this.cacheKey != null) {
            builder.field("_cache_key", this.cacheKey);
        }
        if (this.execution != null) {
            builder.field("execution", this.execution);
        }
        builder.endObject();
    }
}

