/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.cache.filter;

import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.search.DocIdSet;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.base.Objects;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.cache.RemovalListener;
import org.elasticsearch.common.cache.RemovalNotification;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.hppc.ObjectOpenHashSet;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.MemorySizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.index.cache.filter.weighted.WeightedFilterCache;
import org.elasticsearch.node.settings.NodeSettingsService;
import org.elasticsearch.threadpool.ThreadPool;

public class IndicesFilterCache
extends AbstractComponent
implements RemovalListener<WeightedFilterCache.FilterCacheKey, DocIdSet> {
    private final ThreadPool threadPool;
    private Cache<WeightedFilterCache.FilterCacheKey, DocIdSet> cache;
    private volatile String size;
    private volatile long sizeInBytes;
    private volatile TimeValue expire;
    private volatile int concurrencyLevel;
    private final TimeValue cleanInterval;
    private final int minimumEntryWeight;
    private final Set<Object> readersKeysToClean = ConcurrentCollections.newConcurrentSet();
    private volatile boolean closed;
    public static final String INDICES_CACHE_FILTER_SIZE = "indices.cache.filter.size";
    public static final String INDICES_CACHE_FILTER_EXPIRE = "indices.cache.filter.expire";
    public static final String INDICES_CACHE_FILTER_CONCURRENCY_LEVEL = "indices.cache.filter.concurrency_level";
    public static final String INDICES_CACHE_FILTER_CLEAN_INTERVAL = "indices.cache.filter.clean_interval";
    public static final String INDICES_CACHE_FILTER_MINIMUM_ENTRY_WEIGHT = "indices.cache.filter.minimum_entry_weight";

    @Inject
    public IndicesFilterCache(Settings settings, ThreadPool threadPool, NodeSettingsService nodeSettingsService) {
        super(settings);
        this.threadPool = threadPool;
        this.size = settings.get(INDICES_CACHE_FILTER_SIZE, "10%");
        this.expire = settings.getAsTime(INDICES_CACHE_FILTER_EXPIRE, null);
        this.minimumEntryWeight = settings.getAsInt(INDICES_CACHE_FILTER_MINIMUM_ENTRY_WEIGHT, (Integer)1024);
        if (this.minimumEntryWeight <= 0) {
            throw new ElasticsearchIllegalArgumentException("minimum_entry_weight must be > 0 but was: " + this.minimumEntryWeight);
        }
        this.cleanInterval = settings.getAsTime(INDICES_CACHE_FILTER_CLEAN_INTERVAL, TimeValue.timeValueSeconds(60L));
        this.concurrencyLevel = settings.getAsInt(INDICES_CACHE_FILTER_CONCURRENCY_LEVEL, (Integer)16);
        if (this.concurrencyLevel <= 0) {
            throw new ElasticsearchIllegalArgumentException("concurrency_level must be > 0 but was: " + this.concurrencyLevel);
        }
        this.computeSizeInBytes();
        this.buildCache();
        this.logger.debug("using [node] weighted filter cache with size [{}], actual_size [{}], expire [{}], clean_interval [{}]", this.size, new ByteSizeValue(this.sizeInBytes), this.expire, this.cleanInterval);
        nodeSettingsService.addListener(new ApplySettings());
        threadPool.schedule(this.cleanInterval, "same", new ReaderCleaner());
    }

    private void buildCache() {
        CacheBuilder<WeightedFilterCache.FilterCacheKey, DocIdSet> cacheBuilder = CacheBuilder.newBuilder().removalListener(this).maximumWeight(this.sizeInBytes).weigher(new WeightedFilterCache.FilterCacheValueWeigher(this.minimumEntryWeight));
        cacheBuilder.concurrencyLevel(this.concurrencyLevel);
        if (this.expire != null) {
            cacheBuilder.expireAfterAccess(this.expire.millis(), TimeUnit.MILLISECONDS);
        }
        this.cache = cacheBuilder.build();
    }

    private void computeSizeInBytes() {
        this.sizeInBytes = MemorySizeValue.parseBytesSizeValueOrHeapRatio(this.size).bytes();
    }

    public void addReaderKeyToClean(Object readerKey) {
        this.readersKeysToClean.add(readerKey);
    }

    public void close() {
        this.closed = true;
        this.cache.invalidateAll();
    }

    public Cache<WeightedFilterCache.FilterCacheKey, DocIdSet> cache() {
        return this.cache;
    }

    @Override
    public void onRemoval(RemovalNotification<WeightedFilterCache.FilterCacheKey, DocIdSet> removalNotification) {
        WeightedFilterCache.FilterCacheKey key = removalNotification.getKey();
        if (key == null) {
            return;
        }
        if (key.removalListener != null) {
            key.removalListener.onRemoval(removalNotification);
        }
    }

    class ReaderCleaner
    implements Runnable {
        private final ObjectOpenHashSet<Object> keys = ObjectOpenHashSet.newInstance();

        ReaderCleaner() {
        }

        @Override
        public void run() {
            if (IndicesFilterCache.this.closed) {
                return;
            }
            if (IndicesFilterCache.this.readersKeysToClean.isEmpty()) {
                this.schedule();
                return;
            }
            try {
                IndicesFilterCache.this.threadPool.executor("generic").execute(new Runnable(){

                    @Override
                    public void run() {
                        ReaderCleaner.this.keys.clear();
                        Iterator<Object> it = IndicesFilterCache.this.readersKeysToClean.iterator();
                        while (it.hasNext()) {
                            ReaderCleaner.this.keys.add(it.next());
                            it.remove();
                        }
                        if (!ReaderCleaner.this.keys.isEmpty()) {
                            it = IndicesFilterCache.this.cache.asMap().keySet().iterator();
                            while (it.hasNext()) {
                                WeightedFilterCache.FilterCacheKey filterCacheKey = (WeightedFilterCache.FilterCacheKey)it.next();
                                if (!ReaderCleaner.this.keys.contains(filterCacheKey.readerKey())) continue;
                                it.remove();
                            }
                        }
                        IndicesFilterCache.this.cache.cleanUp();
                        ReaderCleaner.this.schedule();
                        ReaderCleaner.this.keys.clear();
                    }
                });
            }
            catch (EsRejectedExecutionException ex) {
                IndicesFilterCache.this.logger.debug("Can not run ReaderCleaner - execution rejected", ex, new Object[0]);
            }
        }

        private void schedule() {
            try {
                IndicesFilterCache.this.threadPool.schedule(IndicesFilterCache.this.cleanInterval, "same", this);
            }
            catch (EsRejectedExecutionException ex) {
                IndicesFilterCache.this.logger.debug("Can not schedule ReaderCleaner - execution rejected", ex, new Object[0]);
            }
        }
    }

    class ApplySettings
    implements NodeSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            int concurrencyLevel;
            TimeValue expire;
            boolean replace = false;
            String size = settings.get(IndicesFilterCache.INDICES_CACHE_FILTER_SIZE, IndicesFilterCache.this.size);
            if (!size.equals(IndicesFilterCache.this.size)) {
                IndicesFilterCache.this.logger.info("updating [{}] from [{}] to [{}]", IndicesFilterCache.INDICES_CACHE_FILTER_SIZE, IndicesFilterCache.this.size, size);
                IndicesFilterCache.this.size = size;
                replace = true;
            }
            if (!Objects.equal(expire = settings.getAsTime(IndicesFilterCache.INDICES_CACHE_FILTER_EXPIRE, IndicesFilterCache.this.expire), IndicesFilterCache.this.expire)) {
                IndicesFilterCache.this.logger.info("updating [{}] from [{}] to [{}]", IndicesFilterCache.INDICES_CACHE_FILTER_EXPIRE, IndicesFilterCache.this.expire, expire);
                IndicesFilterCache.this.expire = expire;
                replace = true;
            }
            if ((concurrencyLevel = settings.getAsInt(IndicesFilterCache.INDICES_CACHE_FILTER_CONCURRENCY_LEVEL, (Integer)IndicesFilterCache.this.concurrencyLevel).intValue()) <= 0) {
                throw new ElasticsearchIllegalArgumentException("concurrency_level must be > 0 but was: " + concurrencyLevel);
            }
            if (!Objects.equal(concurrencyLevel, IndicesFilterCache.this.concurrencyLevel)) {
                IndicesFilterCache.this.logger.info("updating [{}] from [{}] to [{}]", IndicesFilterCache.INDICES_CACHE_FILTER_CONCURRENCY_LEVEL, IndicesFilterCache.this.concurrencyLevel, concurrencyLevel);
                IndicesFilterCache.this.concurrencyLevel = concurrencyLevel;
                replace = true;
            }
            if (replace) {
                Cache oldCache = IndicesFilterCache.this.cache;
                IndicesFilterCache.this.computeSizeInBytes();
                IndicesFilterCache.this.buildCache();
                oldCache.invalidateAll();
            }
        }
    }
}

