/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.percolator;

import java.io.IOException;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.memory.MemoryIndex;
import org.apache.lucene.util.CloseableThreadLocal;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.percolator.PercolateContext;
import org.elasticsearch.percolator.PercolatorIndex;

class SingleDocumentPercolatorIndex
implements PercolatorIndex {
    private final CloseableThreadLocal<MemoryIndex> cache;

    SingleDocumentPercolatorIndex(CloseableThreadLocal<MemoryIndex> cache) {
        this.cache = cache;
    }

    @Override
    public void prepare(PercolateContext context, ParsedDocument parsedDocument) {
        MemoryIndex memoryIndex = (MemoryIndex)this.cache.get();
        for (IndexableField field : parsedDocument.rootDoc().getFields()) {
            if (!field.fieldType().indexed() && field.name().equals("_uid")) continue;
            try {
                TokenStream tokenStream = field.tokenStream(parsedDocument.analyzer(), null);
                if (tokenStream == null) continue;
                memoryIndex.addField(field.name(), tokenStream, field.boost());
            }
            catch (IOException e) {
                throw new ElasticsearchException("Failed to create token stream", e);
            }
        }
        context.initialize(new DocEngineSearcher(memoryIndex), parsedDocument);
    }

    private class DocEngineSearcher
    extends Engine.Searcher {
        private final MemoryIndex memoryIndex;

        public DocEngineSearcher(MemoryIndex memoryIndex) {
            super("percolate", memoryIndex.createSearcher());
            this.memoryIndex = memoryIndex;
        }

        @Override
        public void close() throws ElasticsearchException {
            try {
                this.reader().close();
                this.memoryIndex.reset();
            }
            catch (IOException e) {
                throw new ElasticsearchException("failed to close percolator in-memory index", e);
            }
        }
    }
}

