/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.support;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.Table;
import org.elasticsearch.common.io.UTF8StreamWriter;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.SizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;

public class RestTable {
    public static RestResponse buildResponse(Table table, RestChannel channel) throws Exception {
        RestRequest request = channel.request();
        XContentType xContentType = XContentType.fromRestContentType(request.param("format", request.header("Content-Type")));
        if (xContentType != null) {
            return RestTable.buildXContentBuilder(table, channel);
        }
        return RestTable.buildTextPlainResponse(table, channel);
    }

    public static RestResponse buildXContentBuilder(Table table, RestChannel channel) throws Exception {
        RestRequest request = channel.request();
        XContentBuilder builder = channel.newBuilder();
        List<DisplayHeader> displayHeaders = RestTable.buildDisplayHeaders(table, request);
        builder.startArray();
        for (int row = 0; row < table.getRows().size(); ++row) {
            builder.startObject();
            for (DisplayHeader header : displayHeaders) {
                builder.field(header.display, RestTable.renderValue(request, table.getAsMap().get((Object)header.name).get((int)row).value));
            }
            builder.endObject();
        }
        builder.endArray();
        return new BytesRestResponse(RestStatus.OK, builder);
    }

    public static RestResponse buildTextPlainResponse(Table table, RestChannel channel) throws IOException {
        RestRequest request = channel.request();
        boolean verbose = request.paramAsBoolean("v", false);
        List<DisplayHeader> headers = RestTable.buildDisplayHeaders(table, request);
        int[] width = RestTable.buildWidths(table, request, verbose, headers);
        BytesStreamOutput bytesOut = channel.bytesOutput();
        UTF8StreamWriter out = new UTF8StreamWriter().setOutput(bytesOut);
        if (verbose) {
            for (int col = 0; col < headers.size(); ++col) {
                DisplayHeader header = headers.get(col);
                RestTable.pad(new Table.Cell((Object)header.display, table.findHeaderByName(header.name)), width[col], request, out);
                out.append(" ");
            }
            out.append("\n");
        }
        for (int row = 0; row < table.getRows().size(); ++row) {
            for (int col = 0; col < headers.size(); ++col) {
                DisplayHeader header = headers.get(col);
                RestTable.pad(table.getAsMap().get(header.name).get(row), width[col], request, out);
                out.append(" ");
            }
            out.append("\n");
        }
        out.close();
        return new BytesRestResponse(RestStatus.OK, "text/plain; charset=UTF-8", bytesOut.bytes(), true);
    }

    private static List<DisplayHeader> buildDisplayHeaders(Table table, RestRequest request) {
        String pHeaders = request.param("h");
        ArrayList<DisplayHeader> display = new ArrayList<DisplayHeader>();
        if (pHeaders != null) {
            for (String possibility : Strings.splitStringByCommaToArray(pHeaders)) {
                DisplayHeader dispHeader = null;
                if (table.getAsMap().containsKey(possibility)) {
                    dispHeader = new DisplayHeader(possibility, possibility);
                } else {
                    block1: for (Table.Cell headerCell : table.getHeaders()) {
                        String aliases = headerCell.attr.get("alias");
                        if (aliases == null) continue;
                        for (String alias : Strings.splitStringByCommaToArray(aliases)) {
                            if (!possibility.equals(alias)) continue;
                            dispHeader = new DisplayHeader(headerCell.value.toString(), alias);
                            continue block1;
                        }
                    }
                }
                if (dispHeader == null) continue;
                display.add(dispHeader);
                Table.Cell hcell = table.getHeaderMap().get(dispHeader.name);
                String siblingFlag = hcell.attr.get("sibling");
                if (siblingFlag == null) continue;
                String sibling = siblingFlag + "." + dispHeader.name;
                Table.Cell c = table.getHeaderMap().get(sibling);
                if (c == null || !request.paramAsBoolean(siblingFlag, false)) continue;
                display.add(new DisplayHeader(c.value.toString(), siblingFlag + "." + dispHeader.display));
            }
        } else {
            for (Table.Cell cell : table.getHeaders()) {
                String d = cell.attr.get("default");
                if (!Booleans.parseBoolean(d, true)) continue;
                display.add(new DisplayHeader(cell.value.toString(), cell.value.toString()));
            }
        }
        return display;
    }

    public static int[] buildHelpWidths(Table table, RestRequest request) {
        int[] width = new int[3];
        for (Table.Cell cell : table.getHeaders()) {
            int vWidth;
            String v = RestTable.renderValue(request, cell.value);
            int n = vWidth = v == null ? 0 : v.length();
            if (width[0] < vWidth) {
                width[0] = vWidth;
            }
            v = RestTable.renderValue(request, cell.attr.containsKey("alias") ? cell.attr.get("alias") : "");
            int n2 = vWidth = v == null ? 0 : v.length();
            if (width[1] < vWidth) {
                width[1] = vWidth;
            }
            if (width[2] >= (vWidth = (v = RestTable.renderValue(request, cell.attr.containsKey("desc") ? cell.attr.get("desc") : "not available")) == null ? 0 : v.length())) continue;
            width[2] = vWidth;
        }
        return width;
    }

    private static int[] buildWidths(Table table, RestRequest request, boolean verbose, List<DisplayHeader> headers) {
        int i;
        int[] width = new int[headers.size()];
        if (verbose) {
            i = 0;
            for (DisplayHeader hdr : headers) {
                int vWidth = hdr.display.length();
                if (width[i] < vWidth) {
                    width[i] = vWidth;
                }
                ++i;
            }
        }
        i = 0;
        for (DisplayHeader hdr : headers) {
            for (Table.Cell cell : table.getAsMap().get(hdr.name)) {
                String v = RestTable.renderValue(request, cell.value);
                int vWidth = v == null ? 0 : v.length();
                if (width[i] >= vWidth) continue;
                width[i] = vWidth;
            }
            ++i;
        }
        return width;
    }

    public static void pad(Table.Cell cell, int width, RestRequest request, UTF8StreamWriter out) throws IOException {
        String sValue = RestTable.renderValue(request, cell.value);
        int length = sValue == null ? 0 : sValue.length();
        byte leftOver = (byte)(width - length);
        String textAlign = cell.attr.get("text-align");
        if (textAlign == null) {
            textAlign = "left";
        }
        if (leftOver > 0 && textAlign.equals("right")) {
            for (byte i = 0; i < leftOver; i = (byte)(i + 1)) {
                out.append(" ");
            }
            if (sValue != null) {
                out.append(sValue);
            }
        } else {
            if (sValue != null) {
                out.append(sValue);
            }
            for (byte i = 0; i < leftOver; i = (byte)(i + 1)) {
                out.append(" ");
            }
        }
    }

    private static String renderValue(RestRequest request, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof ByteSizeValue) {
            ByteSizeValue v = (ByteSizeValue)value;
            String resolution = request.param("bytes");
            if ("b".equals(resolution)) {
                return Long.toString(v.bytes());
            }
            if ("k".equals(resolution)) {
                return Long.toString(v.kb());
            }
            if ("m".equals(resolution)) {
                return Long.toString(v.mb());
            }
            if ("g".equals(resolution)) {
                return Long.toString(v.gb());
            }
            if ("t".equals(resolution)) {
                return Long.toString(v.tb());
            }
            if ("p".equals(resolution)) {
                return Long.toString(v.pb());
            }
            return v.toString();
        }
        if (value instanceof SizeValue) {
            SizeValue v = (SizeValue)value;
            String resolution = request.param("size");
            if ("b".equals(resolution)) {
                return Long.toString(v.singles());
            }
            if ("k".equals(resolution)) {
                return Long.toString(v.kilo());
            }
            if ("m".equals(resolution)) {
                return Long.toString(v.mega());
            }
            if ("g".equals(resolution)) {
                return Long.toString(v.giga());
            }
            if ("t".equals(resolution)) {
                return Long.toString(v.tera());
            }
            if ("p".equals(resolution)) {
                return Long.toString(v.peta());
            }
            return v.toString();
        }
        if (value instanceof TimeValue) {
            TimeValue v = (TimeValue)value;
            String resolution = request.param("time");
            if ("ms".equals(resolution)) {
                return Long.toString(v.millis());
            }
            if ("s".equals(resolution)) {
                return Long.toString(v.seconds());
            }
            if ("m".equals(resolution)) {
                return Long.toString(v.minutes());
            }
            if ("h".equals(resolution)) {
                return Long.toString(v.hours());
            }
            return v.toString();
        }
        return value.toString();
    }

    static class DisplayHeader {
        public final String name;
        public final String display;

        DisplayHeader(String name, String display) {
            this.name = name;
            this.display = display;
        }
    }
}

