/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.AtomicReaderContext;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.BucketCollector;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.support.AggregationContext;

public class AggregatorFactories {
    public static final AggregatorFactories EMPTY = new Empty();
    private AggregatorFactory[] factories;

    public static Builder builder() {
        return new Builder();
    }

    private AggregatorFactories(AggregatorFactory[] factories) {
        this.factories = factories;
    }

    private static Aggregator createAndRegisterContextAware(AggregationContext context, AggregatorFactory factory, Aggregator parent, long estimatedBucketsCount) {
        Aggregator aggregator = factory.create(context, parent, estimatedBucketsCount);
        if (aggregator.shouldCollect()) {
            context.registerReaderContextAware(aggregator);
        }
        aggregator.preCollection();
        return aggregator;
    }

    public Aggregator[] createSubAggregators(Aggregator parent, final long estimatedBucketsCount) {
        Aggregator[] aggregators = new Aggregator[this.count()];
        for (int i = 0; i < this.factories.length; ++i) {
            final AggregatorFactory factory = this.factories[i];
            final Aggregator first = AggregatorFactories.createAndRegisterContextAware(parent.context(), factory, parent, estimatedBucketsCount);
            if (first.bucketAggregationMode() == Aggregator.BucketAggregationMode.MULTI_BUCKETS) {
                aggregators[i] = first;
                continue;
            }
            aggregators[i] = new Aggregator(first.name(), Aggregator.BucketAggregationMode.MULTI_BUCKETS, EMPTY, 1L, first.context(), first.parent()){
                ObjectArray<Aggregator> aggregators;
                {
                    super(x0, x1, x2, x3, x4, x5);
                    long arraySize = estimatedBucketsCount > 0L ? estimatedBucketsCount : 1L;
                    this.aggregators = this.bigArrays.newObjectArray(arraySize);
                    this.aggregators.set(0L, first);
                }

                @Override
                public boolean shouldCollect() {
                    return first.shouldCollect();
                }

                @Override
                protected void doPostCollection() throws IOException {
                    for (long i = 0L; i < this.aggregators.size(); ++i) {
                        Aggregator aggregator = this.aggregators.get(i);
                        if (aggregator == null) continue;
                        aggregator.postCollection();
                    }
                }

                @Override
                public void collect(int doc, long owningBucketOrdinal) throws IOException {
                    this.aggregators = this.bigArrays.grow(this.aggregators, owningBucketOrdinal + 1L);
                    Aggregator aggregator = this.aggregators.get(owningBucketOrdinal);
                    if (aggregator == null) {
                        aggregator = AggregatorFactories.createAndRegisterContextAware(this.parent.context(), factory, this.parent, estimatedBucketsCount);
                        this.aggregators.set(owningBucketOrdinal, aggregator);
                    }
                    aggregator.collect(doc, 0L);
                }

                @Override
                public void setNextReader(AtomicReaderContext reader) {
                }

                @Override
                public InternalAggregation buildAggregation(long owningBucketOrdinal) {
                    throw new ElasticsearchIllegalStateException("Invalid context - aggregation must use addResults() to collect child results");
                }

                @Override
                public InternalAggregation buildEmptyAggregation() {
                    return first.buildEmptyAggregation();
                }

                @Override
                public void doClose() {
                    Releasables.close(this.aggregators);
                }

                @Override
                public void gatherAnalysis(BucketCollector.BucketAnalysisCollector results, long owningBucketOrdinal) {
                    if (owningBucketOrdinal >= this.aggregators.size() || this.aggregators.get(owningBucketOrdinal) == null) {
                        results.add(first.buildEmptyAggregation());
                    } else {
                        this.aggregators.get(owningBucketOrdinal).gatherAnalysis(results, 0L);
                    }
                }
            };
            aggregators[i].preCollection();
        }
        return aggregators;
    }

    public Aggregator[] createTopLevelAggregators(AggregationContext ctx) {
        Aggregator[] aggregators = new Aggregator[this.factories.length];
        for (int i = 0; i < this.factories.length; ++i) {
            aggregators[i] = AggregatorFactories.createAndRegisterContextAware(ctx, this.factories[i], null, 0L);
        }
        return aggregators;
    }

    public int count() {
        return this.factories.length;
    }

    void setParent(AggregatorFactory parent) {
        for (AggregatorFactory factory : this.factories) {
            factory.parent = parent;
        }
    }

    public void validate() {
        for (AggregatorFactory factory : this.factories) {
            factory.validate();
        }
    }

    public static class Builder {
        private final Set<String> names = new HashSet<String>();
        private final List<AggregatorFactory> factories = new ArrayList<AggregatorFactory>();

        public Builder add(AggregatorFactory factory) {
            if (!this.names.add(factory.name)) {
                throw new ElasticsearchIllegalArgumentException("Two sibling aggregations cannot have the same name: [" + factory.name + "]");
            }
            this.factories.add(factory);
            return this;
        }

        public AggregatorFactories build() {
            if (this.factories.isEmpty()) {
                return EMPTY;
            }
            return new AggregatorFactories(this.factories.toArray(new AggregatorFactory[this.factories.size()]));
        }
    }

    private static final class Empty
    extends AggregatorFactories {
        private static final AggregatorFactory[] EMPTY_FACTORIES = new AggregatorFactory[0];
        private static final Aggregator[] EMPTY_AGGREGATORS = new Aggregator[0];

        private Empty() {
            super(EMPTY_FACTORIES);
        }

        @Override
        public Aggregator[] createSubAggregators(Aggregator parent, long estimatedBucketsCount) {
            return EMPTY_AGGREGATORS;
        }

        @Override
        public Aggregator[] createTopLevelAggregators(AggregationContext ctx) {
            return EMPTY_AGGREGATORS;
        }
    }
}

