/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.reflection;

import groovy.lang.Closure;
import groovy.lang.ExpandoMetaClass;
import groovy.lang.ExpandoMetaClassCreationHandle;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import groovy.lang.MetaMethod;
import java.lang.ref.PhantomReference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.codehaus.groovy.reflection.CachedClass;
import org.codehaus.groovy.reflection.ClassLoaderForClassArtifacts;
import org.codehaus.groovy.reflection.GroovyClassValue;
import org.codehaus.groovy.reflection.GroovyClassValueFactory;
import org.codehaus.groovy.reflection.stdclasses.ArrayCachedClass;
import org.codehaus.groovy.reflection.stdclasses.BigDecimalCachedClass;
import org.codehaus.groovy.reflection.stdclasses.BigIntegerCachedClass;
import org.codehaus.groovy.reflection.stdclasses.BooleanCachedClass;
import org.codehaus.groovy.reflection.stdclasses.ByteCachedClass;
import org.codehaus.groovy.reflection.stdclasses.CachedClosureClass;
import org.codehaus.groovy.reflection.stdclasses.CachedSAMClass;
import org.codehaus.groovy.reflection.stdclasses.CharacterCachedClass;
import org.codehaus.groovy.reflection.stdclasses.DoubleCachedClass;
import org.codehaus.groovy.reflection.stdclasses.FloatCachedClass;
import org.codehaus.groovy.reflection.stdclasses.IntegerCachedClass;
import org.codehaus.groovy.reflection.stdclasses.LongCachedClass;
import org.codehaus.groovy.reflection.stdclasses.NumberCachedClass;
import org.codehaus.groovy.reflection.stdclasses.ObjectCachedClass;
import org.codehaus.groovy.reflection.stdclasses.ShortCachedClass;
import org.codehaus.groovy.reflection.stdclasses.StringCachedClass;
import org.codehaus.groovy.util.LazyReference;
import org.codehaus.groovy.util.LockableObject;
import org.codehaus.groovy.util.ManagedConcurrentMap;
import org.codehaus.groovy.util.ManagedLinkedList;
import org.codehaus.groovy.util.ManagedReference;
import org.codehaus.groovy.util.ReferenceBundle;
import org.codehaus.groovy.vmplugin.VMPluginFactory;

public class ClassInfo {
    private final LazyCachedClassRef cachedClassRef;
    private final LazyClassLoaderRef artifactClassLoader;
    private final LockableObject lock = new LockableObject();
    public final int hash;
    private final Class klazz;
    private volatile int version;
    private MetaClass strongMetaClass;
    private ManagedReference<MetaClass> weakMetaClass;
    MetaMethod[] dgmMetaMethods = CachedClass.EMPTY;
    MetaMethod[] newMetaMethods = CachedClass.EMPTY;
    private ManagedConcurrentMap<Object, MetaClass> perInstanceMetaClassMap;
    private static ReferenceBundle softBundle = ReferenceBundle.getSoftBundle();
    private static ReferenceBundle weakBundle = ReferenceBundle.getWeakBundle();
    private static final ManagedLinkedList<ClassInfo> modifiedExpandos = new ManagedLinkedList(weakBundle);
    private static final GroovyClassValue<ClassInfo> globalClassValue = GroovyClassValueFactory.createGroovyClassValue(new GroovyClassValue.ComputeValue<ClassInfo>(){

        @Override
        public ClassInfo computeValue(Class<?> type) {
            ClassInfo ret = new ClassInfo(type);
            globalClassSet.add(ret);
            return ret;
        }
    });
    private static final GlobalClassSet globalClassSet = new GlobalClassSet();
    private static final WeakReference<ThreadLocalMapHandler> localMapRef;

    ClassInfo(Class klazz) {
        this.hash = System.identityHashCode(klazz);
        this.klazz = klazz;
        new ClassInfoCleanup(this);
        this.cachedClassRef = new LazyCachedClassRef(softBundle, this);
        this.artifactClassLoader = new LazyClassLoaderRef(softBundle, this);
    }

    public int getVersion() {
        return this.version;
    }

    public void incVersion() {
        ++this.version;
        VMPluginFactory.getPlugin().invalidateCallSites();
    }

    public ExpandoMetaClass getModifiedExpando() {
        MetaClass strongRef = this.strongMetaClass;
        return strongRef == null ? null : (strongRef instanceof ExpandoMetaClass ? (ExpandoMetaClass)strongRef : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearModifiedExpandos() {
        ManagedLinkedList<ClassInfo> managedLinkedList = modifiedExpandos;
        synchronized (managedLinkedList) {
            Iterator<ClassInfo> it = modifiedExpandos.iterator();
            while (it.hasNext()) {
                ClassInfo info = it.next();
                it.remove();
                info.setStrongMetaClass(null);
            }
        }
    }

    public CachedClass getCachedClass() {
        return (CachedClass)this.cachedClassRef.get();
    }

    public ClassLoaderForClassArtifacts getArtifactClassLoader() {
        return (ClassLoaderForClassArtifacts)this.artifactClassLoader.get();
    }

    public static ClassInfo getClassInfo(Class cls) {
        LocalMap map = ClassInfo.getLocalClassInfoMap();
        if (map != null) {
            return map.get(cls);
        }
        return globalClassValue.get(cls);
    }

    private static LocalMap getLocalClassInfoMap() {
        ThreadLocalMapHandler handler = (ThreadLocalMapHandler)localMapRef.get();
        Object ref = null;
        if (handler != null) {
            ref = handler.get();
        }
        LocalMap map = null;
        if (ref != null) {
            map = (LocalMap)((SoftReference)ref).get();
        }
        return map;
    }

    public static Collection<ClassInfo> getAllClassInfo() {
        Collection<ClassInfo> localClassInfos = ClassInfo.getAllLocalClassInfo();
        return localClassInfos != null ? localClassInfos : ClassInfo.getAllGlobalClassInfo();
    }

    public static void onAllClassInfo(ClassInfoAction action) {
        Collection<ClassInfo> localClassInfos = ClassInfo.getAllLocalClassInfo();
        if (localClassInfos != null) {
            for (ClassInfo localClassInfo : localClassInfos) {
                action.onClassInfo(localClassInfo);
            }
        }
        for (ClassInfo classInfo : ClassInfo.getAllGlobalClassInfo()) {
            action.onClassInfo(classInfo);
        }
    }

    private static Collection<ClassInfo> getAllGlobalClassInfo() {
        return globalClassSet.values();
    }

    private static Collection<ClassInfo> getAllLocalClassInfo() {
        LocalMap map = ClassInfo.getLocalClassInfoMap();
        if (map != null) {
            return map.values();
        }
        return globalClassSet.values();
    }

    public MetaClass getStrongMetaClass() {
        return this.strongMetaClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStrongMetaClass(MetaClass answer) {
        ClassInfo info;
        Iterator<ClassInfo> it;
        ManagedLinkedList<ClassInfo> managedLinkedList;
        ++this.version;
        MetaClass strongRef = this.strongMetaClass;
        if (strongRef instanceof ExpandoMetaClass) {
            ((ExpandoMetaClass)strongRef).inRegistry = false;
            managedLinkedList = modifiedExpandos;
            synchronized (managedLinkedList) {
                it = modifiedExpandos.iterator();
                while (it.hasNext()) {
                    info = it.next();
                    if (info != this) continue;
                    it.remove();
                }
            }
        }
        this.strongMetaClass = answer;
        if (answer instanceof ExpandoMetaClass) {
            ((ExpandoMetaClass)answer).inRegistry = true;
            managedLinkedList = modifiedExpandos;
            synchronized (managedLinkedList) {
                it = modifiedExpandos.iterator();
                while (it.hasNext()) {
                    info = it.next();
                    if (info != this) continue;
                    it.remove();
                }
                modifiedExpandos.add(this);
            }
        }
        this.replaceWeakMetaClassRef(null);
    }

    public MetaClass getWeakMetaClass() {
        ManagedReference<MetaClass> weakRef = this.weakMetaClass;
        return weakRef == null ? null : weakRef.get();
    }

    public void setWeakMetaClass(MetaClass answer) {
        ++this.version;
        this.strongMetaClass = null;
        ManagedReference<MetaClass> newRef = null;
        if (answer != null) {
            newRef = new ManagedReference<MetaClass>(softBundle, answer);
        }
        this.replaceWeakMetaClassRef(newRef);
    }

    private void replaceWeakMetaClassRef(ManagedReference<MetaClass> newRef) {
        ManagedReference<MetaClass> weakRef = this.weakMetaClass;
        if (weakRef != null) {
            weakRef.clear();
        }
        this.weakMetaClass = newRef;
    }

    public MetaClass getMetaClassForClass() {
        MetaClass strongMc = this.strongMetaClass;
        if (strongMc != null) {
            return strongMc;
        }
        MetaClass weakMc = this.getWeakMetaClass();
        if (this.isValidWeakMetaClass(weakMc)) {
            return weakMc;
        }
        return null;
    }

    private MetaClass getMetaClassUnderLock() {
        MetaClassRegistry metaClassRegistry;
        MetaClassRegistry.MetaClassCreationHandle mccHandle;
        MetaClass answer = this.getStrongMetaClass();
        if (answer != null) {
            return answer;
        }
        answer = this.getWeakMetaClass();
        if (this.isValidWeakMetaClass(answer, mccHandle = (metaClassRegistry = GroovySystem.getMetaClassRegistry()).getMetaClassCreationHandler())) {
            return answer;
        }
        answer = mccHandle.create(this.klazz, metaClassRegistry);
        answer.initialize();
        if (GroovySystem.isKeepJavaMetaClasses()) {
            this.setStrongMetaClass(answer);
        } else {
            this.setWeakMetaClass(answer);
        }
        return answer;
    }

    private boolean isValidWeakMetaClass(MetaClass metaClass) {
        return this.isValidWeakMetaClass(metaClass, GroovySystem.getMetaClassRegistry().getMetaClassCreationHandler());
    }

    private boolean isValidWeakMetaClass(MetaClass metaClass, MetaClassRegistry.MetaClassCreationHandle mccHandle) {
        if (metaClass == null) {
            return false;
        }
        boolean enableGloballyOn = mccHandle instanceof ExpandoMetaClassCreationHandle;
        boolean cachedAnswerIsEMC = metaClass instanceof ExpandoMetaClass;
        return !enableGloballyOn || cachedAnswerIsEMC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MetaClass getMetaClass() {
        MetaClass answer = this.getMetaClassForClass();
        if (answer != null) {
            return answer;
        }
        this.lock();
        try {
            MetaClass metaClass = this.getMetaClassUnderLock();
            return metaClass;
        }
        finally {
            this.unlock();
        }
    }

    public MetaClass getMetaClass(Object obj) {
        MetaClass instanceMetaClass = this.getPerInstanceMetaClass(obj);
        if (instanceMetaClass != null) {
            return instanceMetaClass;
        }
        return this.getMetaClass();
    }

    public static int size() {
        return globalClassSet.size();
    }

    public static int fullSize() {
        return globalClassSet.fullSize();
    }

    private static CachedClass createCachedClass(Class klazz, ClassInfo classInfo) {
        if (klazz == Object.class) {
            return new ObjectCachedClass(classInfo);
        }
        if (klazz == String.class) {
            return new StringCachedClass(classInfo);
        }
        CachedClass cachedClass = Number.class.isAssignableFrom(klazz) || klazz.isPrimitive() ? (klazz == Number.class ? new NumberCachedClass(klazz, classInfo) : (klazz == Integer.class || klazz == Integer.TYPE ? new IntegerCachedClass(klazz, classInfo, klazz == Integer.class) : (klazz == Double.class || klazz == Double.TYPE ? new DoubleCachedClass(klazz, classInfo, klazz == Double.class) : (klazz == BigDecimal.class ? new BigDecimalCachedClass(klazz, classInfo) : (klazz == Long.class || klazz == Long.TYPE ? new LongCachedClass(klazz, classInfo, klazz == Long.class) : (klazz == Float.class || klazz == Float.TYPE ? new FloatCachedClass(klazz, classInfo, klazz == Float.class) : (klazz == Short.class || klazz == Short.TYPE ? new ShortCachedClass(klazz, classInfo, klazz == Short.class) : (klazz == Boolean.TYPE ? new BooleanCachedClass(klazz, classInfo, false) : (klazz == Character.TYPE ? new CharacterCachedClass(klazz, classInfo, false) : (klazz == BigInteger.class ? new BigIntegerCachedClass(klazz, classInfo) : (klazz == Byte.class || klazz == Byte.TYPE ? new ByteCachedClass(klazz, classInfo, klazz == Byte.class) : new CachedClass(klazz, classInfo)))))))))))) : (klazz.getName().charAt(0) == '[' ? new ArrayCachedClass(klazz, classInfo) : (klazz == Boolean.class ? new BooleanCachedClass(klazz, classInfo, true) : (klazz == Character.class ? new CharacterCachedClass(klazz, classInfo, true) : (Closure.class.isAssignableFrom(klazz) ? new CachedClosureClass(klazz, classInfo) : (ClassInfo.isSAM(klazz) ? new CachedSAMClass(klazz, classInfo) : new CachedClass(klazz, classInfo))))));
        return cachedClass;
    }

    private static boolean isSAM(Class<?> c) {
        return CachedSAMClass.getSAMMethod(c) != null;
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public MetaClass getPerInstanceMetaClass(Object obj) {
        if (this.perInstanceMetaClassMap == null) {
            return null;
        }
        return (MetaClass)this.perInstanceMetaClassMap.get(obj);
    }

    public void setPerInstanceMetaClass(Object obj, MetaClass metaClass) {
        ++this.version;
        if (metaClass != null) {
            if (this.perInstanceMetaClassMap == null) {
                this.perInstanceMetaClassMap = new ManagedConcurrentMap(ReferenceBundle.getWeakBundle());
            }
            this.perInstanceMetaClassMap.put(obj, metaClass);
        } else if (this.perInstanceMetaClassMap != null) {
            this.perInstanceMetaClassMap.remove(obj);
        }
    }

    public boolean hasPerInstanceMetaClasses() {
        return this.perInstanceMetaClassMap != null;
    }

    static {
        ThreadLocalMapHandler localMap = new ThreadLocalMapHandler();
        localMapRef = new WeakReference<ThreadLocalMapHandler>(localMap, null);
    }

    public static interface ClassInfoAction {
        public void onClassInfo(ClassInfo var1);
    }

    private static class GlobalClassSet {
        private ManagedLinkedList<ClassInfo> items = new ManagedLinkedList(ClassInfo.access$800());

        private GlobalClassSet() {
        }

        public int size() {
            return this.values().size();
        }

        public int fullSize() {
            return this.values().size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<ClassInfo> values() {
            ManagedLinkedList<ClassInfo> managedLinkedList = this.items;
            synchronized (managedLinkedList) {
                return Arrays.asList(this.items.toArray((ClassInfo[])new ClassInfo[0]));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(ClassInfo value) {
            ManagedLinkedList<ClassInfo> managedLinkedList = this.items;
            synchronized (managedLinkedList) {
                this.items.add(value);
            }
        }
    }

    private static class DebugRef
    extends ManagedReference<Class> {
        public static final boolean debug = false;
        private static final AtomicInteger count = new AtomicInteger();
        final String name;

        public DebugRef(Class klazz) {
            super(softBundle, klazz);
            this.name = klazz == null ? "<null>" : klazz.getName();
            count.incrementAndGet();
        }

        public void finalizeRef() {
            super.finalizeReference();
        }
    }

    private static class ClassInfoCleanup
    extends ManagedReference<ClassInfo> {
        public ClassInfoCleanup(ClassInfo classInfo) {
            super(weakBundle, classInfo);
        }

        public void finalizeRef() {
            ClassInfo classInfo = (ClassInfo)this.get();
            classInfo.setStrongMetaClass(null);
            classInfo.cachedClassRef.clear();
            classInfo.artifactClassLoader.clear();
        }
    }

    private static class LazyClassLoaderRef
    extends LazyReference<ClassLoaderForClassArtifacts> {
        private final ClassInfo info;

        LazyClassLoaderRef(ReferenceBundle bundle, ClassInfo info) {
            super(bundle);
            this.info = info;
        }

        @Override
        public ClassLoaderForClassArtifacts initValue() {
            return new ClassLoaderForClassArtifacts(this.info.klazz);
        }
    }

    private static class LazyCachedClassRef
    extends LazyReference<CachedClass> {
        private final ClassInfo info;

        LazyCachedClassRef(ReferenceBundle bundle, ClassInfo info) {
            super(bundle);
            this.info = info;
        }

        @Override
        public CachedClass initValue() {
            return ClassInfo.createCachedClass(this.info.klazz, this.info);
        }
    }

    private static class ThreadLocalMapHandler
    extends ThreadLocal<SoftReference<LocalMap>> {
        SoftReference<LocalMap> recentThreadMapRef;

        private ThreadLocalMapHandler() {
        }

        @Override
        protected SoftReference<LocalMap> initialValue() {
            return new SoftReference<LocalMap>(new LocalMap(), null);
        }

        @Override
        public SoftReference<LocalMap> get() {
            SoftReference ref;
            SoftReference<LocalMap> mapRef = this.recentThreadMapRef;
            LocalMap recent = null;
            if (mapRef != null) {
                recent = mapRef.get();
            }
            if (recent != null && recent.myThread.get() == Thread.currentThread()) {
                return mapRef;
            }
            this.recentThreadMapRef = ref = (SoftReference)super.get();
            return ref;
        }
    }

    private static final class LocalMap
    extends HashMap<Class, ClassInfo> {
        private static final int CACHE_SIZE = 5;
        private final PhantomReference<Thread> myThread = new PhantomReference<Thread>(Thread.currentThread(), null);
        private int nextCacheEntry;
        private final ClassInfo[] cache = new ClassInfo[5];
        private static final ClassInfo NOINFO = new ClassInfo(Void.class);

        private LocalMap() {
            for (int i = 0; i < this.cache.length; ++i) {
                this.cache[i] = NOINFO;
            }
        }

        public ClassInfo get(Class key) {
            ClassInfo info = this.getFromCache(key);
            if (info != null) {
                return info;
            }
            info = (ClassInfo)super.get(key);
            if (info != null) {
                return this.putToCache(info);
            }
            return this.putToCache((ClassInfo)globalClassValue.get(key));
        }

        private ClassInfo getFromCache(Class klazz) {
            int i = 0;
            int k = this.nextCacheEntry - 1;
            while (i < this.cache.length) {
                ClassInfo info;
                if (k < 0) {
                    k += 5;
                }
                if (klazz == (info = this.cache[k]).klazz) {
                    this.nextCacheEntry = k + 1;
                    if (this.nextCacheEntry == 5) {
                        this.nextCacheEntry = 0;
                    }
                    return info;
                }
                ++i;
                --k;
            }
            return null;
        }

        private ClassInfo putToCache(ClassInfo classInfo) {
            this.cache[this.nextCacheEntry++] = classInfo;
            if (this.nextCacheEntry == 5) {
                this.nextCacheEntry = 0;
            }
            return classInfo;
        }
    }
}

