/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.adapter.impl;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.nuxeo.drive.adapter.FileItem;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.FolderItem;
import org.nuxeo.drive.adapter.impl.DefaultSyncRootFolderItem;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.runtime.api.Framework;

public class CollectionSyncRootFolderItem
extends DefaultSyncRootFolderItem
implements FolderItem {
    private static final long serialVersionUID = 1L;

    public CollectionSyncRootFolderItem(String factoryName, FolderItem parentItem, DocumentModel doc) {
        this(factoryName, parentItem, doc, false);
    }

    public CollectionSyncRootFolderItem(String factoryName, FolderItem parentItem, DocumentModel doc, boolean relaxSyncRootConstraint) {
        super(factoryName, parentItem, doc, relaxSyncRootConstraint);
    }

    protected CollectionSyncRootFolderItem() {
    }

    @Override
    public List<FileSystemItem> getChildren() {
        try (CoreSession session = CoreInstance.openCoreSession((String)this.repositoryName, (Principal)this.principal);){
            PageProviderService pageProviderService = (PageProviderService)Framework.getLocalService(PageProviderService.class);
            HashMap<String, Serializable> props = new HashMap<String, Serializable>();
            props.put("coreSession", (Serializable)session);
            PageProvider childrenPageProvider = pageProviderService.getPageProvider("default_content_collection", null, null, Long.valueOf(0L), props, new Object[]{this.docId});
            List dmChildren = childrenPageProvider.getCurrentPage();
            ArrayList<FileSystemItem> children = new ArrayList<FileSystemItem>(dmChildren.size());
            for (DocumentModel dmChild : dmChildren) {
                FileSystemItem child = this.getFileSystemItemAdapterService().getFileSystemItem(dmChild, this);
                if (child == null) continue;
                children.add(child);
            }
            ArrayList<FileSystemItem> arrayList = children;
            return arrayList;
        }
    }

    @Override
    public FolderItem createFolder(String name) {
        throw new UnsupportedOperationException("Cannot create a folder in a collection synchronization root.");
    }

    @Override
    public FileItem createFile(Blob blob) {
        throw new UnsupportedOperationException("Cannot create a file in a collection synchronization root.");
    }

    @Override
    protected final void initialize(DocumentModel doc) {
        super.initialize(doc);
        this.canCreateChild = false;
    }
}

