/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.service.impl;

import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.drive.service.FileSystemChangeFinder;
import org.nuxeo.drive.service.impl.ChangeFinderDescriptor;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class ChangeFinderRegistry
extends ContributionFragmentRegistry<ChangeFinderDescriptor> {
    private static final Log log = LogFactory.getLog(ChangeFinderRegistry.class);
    protected static final String CONTRIBUTION_ID = "changeFinderContrib";
    protected FileSystemChangeFinder changeFinder;

    public String getContributionId(ChangeFinderDescriptor contrib) {
        return CONTRIBUTION_ID;
    }

    public void contributionUpdated(String id, ChangeFinderDescriptor contrib, ChangeFinderDescriptor newOrigContrib) {
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("Updating change finder contribution %s.", contrib));
            }
            this.changeFinder = contrib.getChangeFinder();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new NuxeoException("Cannot update changeFinder contribution.", (Throwable)e);
        }
    }

    public void contributionRemoved(String id, ChangeFinderDescriptor origContrib) {
        log.trace((Object)"Clearing change finder.");
        this.changeFinder = null;
    }

    public ChangeFinderDescriptor clone(ChangeFinderDescriptor orig) {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Cloning contribution %s.", orig));
        }
        ChangeFinderDescriptor clone = new ChangeFinderDescriptor();
        clone.changeFinderClass = orig.changeFinderClass;
        clone.parameters = orig.parameters;
        return clone;
    }

    public void merge(ChangeFinderDescriptor src, ChangeFinderDescriptor dst) {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Merging contribution %s to contribution %s.", src, dst));
        }
        if (src.getChangeFinderClass() != null && !src.getChangeFinderClass().equals(dst.getChangeFinderClass())) {
            dst.setChangeFinderClass(src.getChangeFinderClass());
        }
        if (!MapUtils.isEmpty(src.getParameters())) {
            for (String name : src.getParameters().keySet()) {
                dst.setParameter(name, src.getparameter(name));
            }
        }
    }
}

