/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.binary.metadata.internals.listeners;

import java.io.Serializable;
import org.nuxeo.binary.metadata.api.BinaryMetadataService;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.runtime.api.Framework;

public class BinaryMetadataSyncListener
implements EventListener {
    public void handleEvent(Event event) {
        EventContext ctx = event.getContext();
        if (!(ctx instanceof DocumentEventContext)) {
            return;
        }
        BinaryMetadataService binaryMetadataService = (BinaryMetadataService)Framework.getLocalService(BinaryMetadataService.class);
        DocumentEventContext docCtx = (DocumentEventContext)ctx;
        DocumentModel doc = docCtx.getSourceDocument();
        Boolean disable = (Boolean)event.getContext().getProperty("disableBinaryMetadataListener");
        if ("aboutToCreate".equals(event.getName()) && !doc.isProxy() && disable == null) {
            binaryMetadataService.writeMetadata(doc, docCtx.getCoreSession());
        } else if ("beforeDocumentModification".equals(event.getName()) && !doc.isProxy() && disable == null) {
            doc.putContextData("disableBinaryMetadataListener", (Serializable)Boolean.TRUE);
            binaryMetadataService.handleSyncUpdate(doc, docCtx);
        }
    }
}

