/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.ws;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import org.nuxeo.ecm.core.schema.utils.DateParser;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.api.Logs;
import org.nuxeo.ecm.platform.audit.ws.BatchHelper;
import org.nuxeo.ecm.platform.audit.ws.BatchInfo;
import org.nuxeo.ecm.platform.audit.ws.EventDescriptor;
import org.nuxeo.ecm.platform.audit.ws.EventDescriptorPage;
import org.nuxeo.ecm.platform.audit.ws.ModifiedDocumentDescriptor;
import org.nuxeo.ecm.platform.audit.ws.ModifiedDocumentDescriptorPage;
import org.nuxeo.ecm.platform.audit.ws.api.WSAudit;
import org.nuxeo.ecm.platform.ws.AbstractNuxeoWebService;
import org.nuxeo.runtime.api.Framework;

@WebService(name="WSAuditInterface", serviceName="WSAuditService")
@SOAPBinding(style=SOAPBinding.Style.DOCUMENT)
public class WSAuditBean
extends AbstractNuxeoWebService
implements WSAudit {
    private static final long serialVersionUID = 1L;

    protected final Logs getLogsBean() {
        return (Logs)Framework.getService(Logs.class);
    }

    @Override
    @WebMethod
    public ModifiedDocumentDescriptor[] listModifiedDocuments(@WebParam(name="sessionId") String sessionId, @WebParam(name="dataRangeQuery") String dateRangeQuery) {
        this.initSession(sessionId);
        BatchInfo batchInfo = BatchHelper.getBatchInfo(sessionId, dateRangeQuery);
        List logEntries = this.getLogsBean().queryLogsByPage(null, batchInfo.getPageDateRange(), "eventDocumentCategory", null, batchInfo.getNextPage(), batchInfo.getPageSize());
        if (logEntries.size() < batchInfo.getPageSize()) {
            BatchHelper.resetBatchInfo(sessionId);
        } else {
            batchInfo.prepareNextCall();
        }
        ArrayList<ModifiedDocumentDescriptor> ldocs = new ArrayList<ModifiedDocumentDescriptor>();
        HashSet<String> uuids = new HashSet<String>();
        for (LogEntry logEntry : logEntries) {
            if (uuids.contains(logEntry.getDocUUID())) continue;
            uuids.add(logEntry.getDocUUID());
            ldocs.add(new ModifiedDocumentDescriptor(logEntry.getEventDate(), logEntry.getDocType(), logEntry.getDocUUID()));
        }
        ModifiedDocumentDescriptor[] docs = new ModifiedDocumentDescriptor[ldocs.size()];
        ldocs.toArray(docs);
        return docs;
    }

    @Override
    @WebMethod
    public ModifiedDocumentDescriptorPage listModifiedDocumentsByPage(@WebParam(name="sessionId") String sessionId, @WebParam(name="dataRangeQuery") String dateRangeQuery, @WebParam(name="docPath") String path, @WebParam(name="pageIndex") int page, @WebParam(name="pageSize") int pageSize) {
        this.initSession(sessionId);
        List logEntries = this.getLogsBean().queryLogsByPage(null, dateRangeQuery, "eventDocumentCategory", path, page, pageSize);
        boolean hasMorePage = logEntries.size() >= pageSize;
        ArrayList<ModifiedDocumentDescriptor> ldocs = new ArrayList<ModifiedDocumentDescriptor>();
        HashSet<String> uuids = new HashSet<String>();
        for (LogEntry logEntry : logEntries) {
            if (uuids.contains(logEntry.getDocUUID())) continue;
            uuids.add(logEntry.getDocUUID());
            ldocs.add(new ModifiedDocumentDescriptor(logEntry.getEventDate(), logEntry.getDocType(), logEntry.getDocUUID()));
        }
        ModifiedDocumentDescriptor[] docs = new ModifiedDocumentDescriptor[ldocs.size()];
        ldocs.toArray(docs);
        return new ModifiedDocumentDescriptorPage(docs, page, hasMorePage);
    }

    @Override
    @WebMethod
    public ModifiedDocumentDescriptorPage listDeletedDocumentsByPage(@WebParam(name="sessionId") String sessionId, @WebParam(name="dataRangeQuery") String dateRangeQuery, @WebParam(name="docPath") String path, @WebParam(name="pageIndex") int page, @WebParam(name="pageSize") int pageSize) {
        this.initSession(sessionId);
        String[] eventIds = new String[]{"documentRemoved"};
        List logEntries = this.getLogsBean().queryLogsByPage(eventIds, dateRangeQuery, "eventDocumentCategory", path, page, pageSize);
        boolean hasMorePage = logEntries.size() >= pageSize;
        ArrayList<ModifiedDocumentDescriptor> ldocs = new ArrayList<ModifiedDocumentDescriptor>();
        HashSet<String> uuids = new HashSet<String>();
        for (LogEntry logEntry : logEntries) {
            if (uuids.contains(logEntry.getDocUUID())) continue;
            uuids.add(logEntry.getDocUUID());
            ldocs.add(new ModifiedDocumentDescriptor(logEntry.getEventDate(), logEntry.getDocType(), logEntry.getDocUUID()));
        }
        ModifiedDocumentDescriptor[] docs = new ModifiedDocumentDescriptor[ldocs.size()];
        ldocs.toArray(docs);
        return new ModifiedDocumentDescriptorPage(docs, page, hasMorePage);
    }

    @Override
    @WebMethod
    public EventDescriptorPage listEventsByPage(@WebParam(name="sessionId") String sessionId, @WebParam(name="dataRangeQuery") String dateRangeQuery, @WebParam(name="pageIndex") int page, @WebParam(name="pageSize") int pageSize) {
        this.initSession(sessionId);
        String[] categories = new String[]{};
        List logEntries = this.getLogsBean().queryLogsByPage(null, dateRangeQuery, categories, null, page, pageSize);
        boolean hasMorePage = logEntries.size() >= pageSize;
        ArrayList<EventDescriptor> events = new ArrayList<EventDescriptor>();
        for (LogEntry logEntry : logEntries) {
            events.add(new EventDescriptor(logEntry));
        }
        EventDescriptor[] evts = new EventDescriptor[events.size()];
        events.toArray(evts);
        return new EventDescriptorPage(evts, page, hasMorePage);
    }

    @Override
    @WebMethod
    public EventDescriptorPage listDocumentEventsByPage(@WebParam(name="sessionId") String sessionId, @WebParam(name="dataRangeQuery") String dateRangeQuery, @WebParam(name="startDate") String startDate, @WebParam(name="path") String path, @WebParam(name="pageIndex") int page, @WebParam(name="pageSize") int pageSize) {
        List logEntries;
        this.initSession(sessionId);
        String[] docCategories = new String[]{"eventDocumentCategory", "eventLifeCycleCategory"};
        if (dateRangeQuery != null && dateRangeQuery.length() > 0) {
            logEntries = this.getLogsBean().queryLogsByPage(null, dateRangeQuery, docCategories, path, page, pageSize);
        } else {
            Date limit = DateParser.parseW3CDateTime((String)startDate);
            logEntries = this.getLogsBean().queryLogsByPage(null, limit, docCategories, path, page, pageSize);
        }
        boolean hasMorePage = logEntries.size() >= pageSize;
        ArrayList<EventDescriptor> events = new ArrayList<EventDescriptor>();
        for (LogEntry logEntry : logEntries) {
            events.add(new EventDescriptor(logEntry));
        }
        EventDescriptor[] evts = new EventDescriptor[events.size()];
        events.toArray(evts);
        return new EventDescriptorPage(evts, page, hasMorePage);
    }

    @Override
    @WebMethod
    public EventDescriptorPage queryEventsByPage(@WebParam(name="sessionId") String sessionId, @WebParam(name="whereClause") String whereClause, @WebParam(name="pageIndex") int page, @WebParam(name="pageSize") int pageSize) {
        this.initSession(sessionId);
        List logEntries = this.getLogsBean().nativeQueryLogs(whereClause, page, pageSize);
        boolean hasMorePage = logEntries.size() >= pageSize;
        ArrayList<EventDescriptor> events = new ArrayList<EventDescriptor>();
        for (LogEntry logEntry : logEntries) {
            events.add(new EventDescriptor(logEntry));
        }
        EventDescriptor[] evts = new EventDescriptor[events.size()];
        events.toArray(evts);
        return new EventDescriptorPage(evts, page, hasMorePage);
    }
}

