/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs.batch;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.server.jaxrs.batch.BatchFileEntry;
import org.nuxeo.ecm.automation.server.jaxrs.batch.BatchManager;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.transientstore.api.TransientStore;
import org.nuxeo.runtime.api.Framework;

public class Batch {
    protected static final Log log = LogFactory.getLog(Batch.class);
    public static final String CHUNKED_PARAM_NAME = "chunked";
    protected String key;
    protected Map<String, Serializable> fileEntries;

    public Batch(String key) {
        this(key, new HashMap<String, Serializable>());
    }

    public Batch(String key, Map<String, Serializable> fileEntries) {
        this.key = key;
        this.fileEntries = fileEntries;
    }

    public String getKey() {
        return this.key;
    }

    public List<Blob> getBlobs() {
        ArrayList<Blob> blobs = new ArrayList<Blob>();
        List<String> sortedFileIndexes = this.getOrderedFileIndexes();
        log.debug((Object)String.format("Retrieving blobs for batch %s: %s", this.key, sortedFileIndexes));
        for (String index : sortedFileIndexes) {
            Blob blob = this.retrieveBlob(index);
            if (blob == null) continue;
            blobs.add(blob);
        }
        return blobs;
    }

    public Blob getBlob(String index) {
        log.debug((Object)String.format("Retrieving blob %s for batch %s", index, this.key));
        return this.retrieveBlob(index);
    }

    protected List<String> getOrderedFileIndexes() {
        ArrayList<String> sortedFileIndexes = new ArrayList<String>(this.fileEntries.keySet());
        Collections.sort(sortedFileIndexes, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return Integer.valueOf(o1).compareTo(Integer.valueOf(o2));
            }
        });
        return sortedFileIndexes;
    }

    protected Blob retrieveBlob(String index) {
        Blob blob = null;
        BatchFileEntry fileEntry = this.getFileEntry(index);
        if (fileEntry != null) {
            blob = fileEntry.getBlob();
        }
        return blob;
    }

    public List<BatchFileEntry> getFileEntries() {
        ArrayList<BatchFileEntry> batchFileEntries = new ArrayList<BatchFileEntry>();
        List<String> sortedFileIndexes = this.getOrderedFileIndexes();
        for (String index : sortedFileIndexes) {
            BatchFileEntry fileEntry = this.getFileEntry(index);
            if (fileEntry == null) continue;
            batchFileEntries.add(fileEntry);
        }
        return batchFileEntries;
    }

    public BatchFileEntry getFileEntry(String index) {
        return this.getFileEntry(index, true);
    }

    public BatchFileEntry getFileEntry(String index, boolean fetchBlobs) {
        BatchManager bm = (BatchManager)Framework.getService(BatchManager.class);
        String fileEntryKey = (String)((Object)this.fileEntries.get(index));
        if (fileEntryKey == null) {
            return null;
        }
        TransientStore ts = bm.getTransientStore();
        Map fileEntryParams = ts.getParameters(fileEntryKey);
        if (fileEntryParams == null) {
            return null;
        }
        boolean chunked = Boolean.parseBoolean((String)fileEntryParams.get(CHUNKED_PARAM_NAME));
        if (chunked) {
            return new BatchFileEntry(fileEntryKey, fileEntryParams);
        }
        Blob blob = null;
        if (fetchBlobs) {
            List fileEntryBlobs = ts.getBlobs(fileEntryKey);
            if (fileEntryBlobs == null) {
                return null;
            }
            if (!fileEntryBlobs.isEmpty()) {
                blob = (Blob)fileEntryBlobs.get(0);
            }
        }
        return new BatchFileEntry(fileEntryKey, blob);
    }

    public String addFile(String index, InputStream is, String name, String mime) throws IOException {
        String mimeType = mime;
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        Blob blob = Blobs.createBlob((InputStream)is, (String)mime);
        blob.setFilename(name);
        String fileEntryKey = this.key + "_" + index;
        BatchManager bm = (BatchManager)Framework.getService(BatchManager.class);
        TransientStore ts = bm.getTransientStore();
        ts.putBlobs(fileEntryKey, Collections.singletonList(blob));
        ts.putParameter(fileEntryKey, CHUNKED_PARAM_NAME, (Serializable)((Object)String.valueOf(false)));
        ts.putParameter(this.key, index, (Serializable)((Object)fileEntryKey));
        return fileEntryKey;
    }

    public String addChunk(String index, InputStream is, int chunkCount, int chunkIndex, String fileName, String mimeType, long fileSize) throws IOException {
        BatchManager bm = (BatchManager)Framework.getService(BatchManager.class);
        Blob blob = Blobs.createBlob((InputStream)is);
        String fileEntryKey = this.key + "_" + index;
        BatchFileEntry fileEntry = this.getFileEntry(index);
        if (fileEntry == null) {
            fileEntry = new BatchFileEntry(fileEntryKey, chunkCount, fileName, mimeType, fileSize);
            TransientStore ts = bm.getTransientStore();
            ts.putParameters(fileEntryKey, fileEntry.getParams());
            ts.putParameter(this.key, index, (Serializable)((Object)fileEntryKey));
        }
        fileEntry.addChunk(chunkIndex, blob);
        return fileEntryKey;
    }

    public void clean() {
        log.debug((Object)String.format("Cleaning batch %s", this.key));
        BatchManager bm = (BatchManager)Framework.getService(BatchManager.class);
        TransientStore ts = bm.getTransientStore();
        for (String fileIndex : this.fileEntries.keySet()) {
            String fileEntryKey;
            List fileBlobs;
            BatchFileEntry fileEntry = this.getFileEntry(fileIndex, false);
            if (fileEntry == null) continue;
            if (fileEntry.isChunked()) {
                for (String chunkEntryKey : fileEntry.getChunkEntryKeys()) {
                    List chunkBlobs = ts.getBlobs(chunkEntryKey);
                    if (chunkBlobs != null) {
                        for (Blob blob : chunkBlobs) {
                            try {
                                FileUtils.deleteDirectory((File)blob.getFile().getParentFile());
                            }
                            catch (IOException e) {
                                log.error((Object)"Error while deleting chunk parent directory", (Throwable)e);
                            }
                        }
                    }
                    ts.remove(chunkEntryKey);
                }
                fileEntry.beforeRemove();
            }
            if ((fileBlobs = ts.getBlobs(fileEntryKey = fileEntry.getKey())) != null) {
                for (Blob blob : fileBlobs) {
                    try {
                        FileUtils.deleteDirectory((File)blob.getFile().getParentFile());
                    }
                    catch (IOException e) {
                        log.error((Object)"Error while deleting file parent directory", (Throwable)e);
                    }
                }
            }
            ts.remove(fileEntryKey);
        }
        ts.remove(this.key);
    }
}

