/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.auth.saml.binding;

import org.opensaml.common.binding.decoding.BaseSAMLMessageDecoder;
import org.opensaml.common.binding.decoding.URIComparator;
import org.opensaml.util.SimpleURLCanonicalizer;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.decoder.MessageDecoder;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.ws.message.encoder.MessageEncoder;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.ws.transport.InTransport;
import org.opensaml.ws.transport.OutTransport;
import org.opensaml.xml.security.SecurityException;

public abstract class SAMLBinding {
    protected MessageDecoder decoder;
    protected MessageEncoder encoder;
    public static final URIComparator uriComparator = new URIComparator(){

        public boolean compare(String uri1, String uri2) {
            if (uri1 == null && uri2 == null) {
                return true;
            }
            if (uri1 == null || uri2 == null) {
                return false;
            }
            String uri1Canon = SimpleURLCanonicalizer.canonicalize((String)uri1).replaceFirst("^(https:|http:)", "");
            String uri2Canon = SimpleURLCanonicalizer.canonicalize((String)uri2).replaceFirst("^(https:|http:)", "");
            return uri1Canon.equals(uri2Canon);
        }
    };

    public SAMLBinding(MessageDecoder decoder, MessageEncoder encoder) {
        this.decoder = decoder;
        this.encoder = encoder;
        if (decoder != null) {
            ((BaseSAMLMessageDecoder)decoder).setURIComparator(uriComparator);
        }
    }

    public void decode(MessageContext context) throws SecurityException, MessageDecodingException {
        this.decoder.decode(context);
    }

    public void encode(MessageContext context) throws MessageEncodingException {
        this.encoder.encode(context);
    }

    public abstract String getBindingURI();

    public abstract boolean supports(InTransport var1);

    public abstract boolean supports(OutTransport var1);
}

