/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.filters;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.owasp.esapi.errors.AccessControlException;
import org.owasp.esapi.errors.ValidationException;

public class SecurityWrapperRequest
extends HttpServletRequestWrapper
implements HttpServletRequest {
    private final Logger logger = ESAPI.getLogger("SecurityWrapperRequest");
    private String allowableContentRoot = "WEB-INF";

    public SecurityWrapperRequest(HttpServletRequest request) {
        super(request);
    }

    private HttpServletRequest getHttpServletRequest() {
        return (HttpServletRequest)super.getRequest();
    }

    public Object getAttribute(String name) {
        return this.getHttpServletRequest().getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this.getHttpServletRequest().getAttributeNames();
    }

    public String getAuthType() {
        return this.getHttpServletRequest().getAuthType();
    }

    public String getCharacterEncoding() {
        return this.getHttpServletRequest().getCharacterEncoding();
    }

    public int getContentLength() {
        return this.getHttpServletRequest().getContentLength();
    }

    public String getContentType() {
        return this.getHttpServletRequest().getContentType();
    }

    public String getContextPath() {
        String path = this.getHttpServletRequest().getContextPath();
        if (path == null || "".equals(path.trim())) {
            return "";
        }
        String clean = "";
        try {
            clean = ESAPI.validator().getValidInput("HTTP context path: " + path, path, "HTTPContextPath", 150, false);
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return clean;
    }

    public Cookie[] getCookies() {
        Cookie[] cookies = this.getHttpServletRequest().getCookies();
        if (cookies == null) {
            return new Cookie[0];
        }
        ArrayList<Cookie> newCookies = new ArrayList<Cookie>();
        for (Cookie c : cookies) {
            try {
                String name = ESAPI.validator().getValidInput("Cookie name: " + c.getName(), c.getName(), "HTTPCookieName", 150, true);
                String value = ESAPI.validator().getValidInput("Cookie value: " + c.getValue(), c.getValue(), "HTTPCookieValue", 1000, true);
                int maxAge = c.getMaxAge();
                String domain = c.getDomain();
                String path = c.getPath();
                Cookie n = new Cookie(name, value);
                n.setMaxAge(maxAge);
                if (domain != null) {
                    n.setDomain(ESAPI.validator().getValidInput("Cookie domain: " + domain, domain, "HTTPHeaderValue", 200, false));
                }
                if (path != null) {
                    n.setPath(ESAPI.validator().getValidInput("Cookie path: " + path, path, "HTTPHeaderValue", 200, false));
                }
                newCookies.add(n);
            }
            catch (ValidationException e) {
                this.logger.warning(Logger.SECURITY_FAILURE, "Skipping bad cookie: " + c.getName() + "=" + c.getValue(), e);
            }
        }
        return newCookies.toArray(new Cookie[newCookies.size()]);
    }

    public long getDateHeader(String name) {
        return this.getHttpServletRequest().getDateHeader(name);
    }

    public String getHeader(String name) {
        String value = this.getHttpServletRequest().getHeader(name);
        String clean = "";
        try {
            clean = ESAPI.validator().getValidInput("HTTP header value: " + value, value, "HTTPHeaderValue", 150, true);
        }
        catch (ValidationException e) {
            // empty catch block
        }
        return clean;
    }

    public Enumeration getHeaderNames() {
        Vector<String> v = new Vector<String>();
        Enumeration en = this.getHttpServletRequest().getHeaderNames();
        while (en.hasMoreElements()) {
            try {
                String name = (String)en.nextElement();
                String clean = ESAPI.validator().getValidInput("HTTP header name: " + name, name, "HTTPHeaderName", 150, true);
                v.add(clean);
            }
            catch (ValidationException validationException) {}
        }
        return v.elements();
    }

    public Enumeration getHeaders(String name) {
        Vector<String> v = new Vector<String>();
        Enumeration en = this.getHttpServletRequest().getHeaders(name);
        while (en.hasMoreElements()) {
            try {
                String value = (String)en.nextElement();
                String clean = ESAPI.validator().getValidInput("HTTP header value (" + name + "): " + value, value, "HTTPHeaderValue", 150, true);
                v.add(clean);
            }
            catch (ValidationException e) {}
        }
        return v.elements();
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.getHttpServletRequest().getInputStream();
    }

    public int getIntHeader(String name) {
        return this.getHttpServletRequest().getIntHeader(name);
    }

    public String getLocalAddr() {
        return this.getHttpServletRequest().getLocalAddr();
    }

    public Locale getLocale() {
        return this.getHttpServletRequest().getLocale();
    }

    public Enumeration getLocales() {
        return this.getHttpServletRequest().getLocales();
    }

    public String getLocalName() {
        return this.getHttpServletRequest().getLocalName();
    }

    public int getLocalPort() {
        return this.getHttpServletRequest().getLocalPort();
    }

    public String getMethod() {
        return this.getHttpServletRequest().getMethod();
    }

    public String getParameter(String name) {
        return this.getParameter(name, true);
    }

    public String getParameter(String name, boolean allowNull) {
        return this.getParameter(name, allowNull, 2000, "HTTPParameterValue");
    }

    public String getParameter(String name, boolean allowNull, int maxLength) {
        return this.getParameter(name, allowNull, maxLength, "HTTPParameterValue");
    }

    public String getParameter(String name, boolean allowNull, int maxLength, String regexName) {
        String orig = this.getHttpServletRequest().getParameter(name);
        String clean = null;
        try {
            clean = ESAPI.validator().getValidInput("HTTP parameter name: " + name, orig, regexName, maxLength, allowNull);
        }
        catch (ValidationException e) {
            // empty catch block
        }
        return clean;
    }

    public Map getParameterMap() {
        Map map = this.getHttpServletRequest().getParameterMap();
        HashMap<String, String[]> cleanMap = new HashMap<String, String[]>();
        for (Map.Entry o : map.entrySet()) {
            try {
                Map.Entry e = o;
                String name = (String)e.getKey();
                String cleanName = ESAPI.validator().getValidInput("HTTP parameter name: " + name, name, "HTTPParameterName", 100, true);
                String[] value = (String[])e.getValue();
                String[] cleanValues = new String[value.length];
                for (int j = 0; j < value.length; ++j) {
                    String cleanValue;
                    cleanValues[j] = cleanValue = ESAPI.validator().getValidInput("HTTP parameter value: " + value[j], value[j], "HTTPParameterValue", 2000, true);
                }
                cleanMap.put(cleanName, cleanValues);
            }
            catch (ValidationException e) {}
        }
        return cleanMap;
    }

    public Enumeration getParameterNames() {
        Vector<String> v = new Vector<String>();
        Enumeration en = this.getHttpServletRequest().getParameterNames();
        while (en.hasMoreElements()) {
            try {
                String name = (String)en.nextElement();
                String clean = ESAPI.validator().getValidInput("HTTP parameter name: " + name, name, "HTTPParameterName", 150, true);
                v.add(clean);
            }
            catch (ValidationException validationException) {}
        }
        return v.elements();
    }

    public String[] getParameterValues(String name) {
        String[] values = this.getHttpServletRequest().getParameterValues(name);
        if (values == null) {
            return null;
        }
        ArrayList<String> newValues = new ArrayList<String>();
        for (String value : values) {
            try {
                String cleanValue = ESAPI.validator().getValidInput("HTTP parameter value: " + value, value, "HTTPParameterValue", 2000, true);
                newValues.add(cleanValue);
            }
            catch (ValidationException e) {
                this.logger.warning(Logger.SECURITY_FAILURE, "Skipping bad parameter");
            }
        }
        return newValues.toArray(new String[newValues.size()]);
    }

    public String getPathInfo() {
        String path = this.getHttpServletRequest().getPathInfo();
        if (path == null) {
            return null;
        }
        String clean = "";
        try {
            clean = ESAPI.validator().getValidInput("HTTP path: " + path, path, "HTTPPath", 150, true);
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return clean;
    }

    public String getPathTranslated() {
        return this.getHttpServletRequest().getPathTranslated();
    }

    public String getProtocol() {
        return this.getHttpServletRequest().getProtocol();
    }

    public String getQueryString() {
        String query = this.getHttpServletRequest().getQueryString();
        String clean = "";
        try {
            clean = ESAPI.validator().getValidInput("HTTP query string: " + query, query, "HTTPQueryString", 2000, true);
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return clean;
    }

    public BufferedReader getReader() throws IOException {
        return this.getHttpServletRequest().getReader();
    }

    @Deprecated
    public String getRealPath(String path) {
        return this.getHttpServletRequest().getRealPath(path);
    }

    public String getRemoteAddr() {
        return this.getHttpServletRequest().getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.getHttpServletRequest().getRemoteHost();
    }

    public int getRemotePort() {
        return this.getHttpServletRequest().getRemotePort();
    }

    public String getRemoteUser() {
        return ESAPI.authenticator().getCurrentUser().getAccountName();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (path.startsWith(this.allowableContentRoot)) {
            return this.getHttpServletRequest().getRequestDispatcher(path);
        }
        return null;
    }

    public String getRequestedSessionId() {
        String id = this.getHttpServletRequest().getRequestedSessionId();
        String clean = "";
        try {
            clean = ESAPI.validator().getValidInput("Requested cookie: " + id, id, "HTTPJSESSIONID", 50, false);
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return clean;
    }

    public String getRequestURI() {
        String uri = this.getHttpServletRequest().getRequestURI();
        String clean = "";
        try {
            clean = ESAPI.validator().getValidInput("HTTP URI: " + uri, uri, "HTTPURI", 2000, false);
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return clean;
    }

    public StringBuffer getRequestURL() {
        String url = this.getHttpServletRequest().getRequestURL().toString();
        String clean = "";
        try {
            clean = ESAPI.validator().getValidInput("HTTP URL: " + url, url, "HTTPURL", 2000, false);
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return new StringBuffer(clean);
    }

    public String getScheme() {
        String scheme = this.getHttpServletRequest().getScheme();
        String clean = "";
        try {
            clean = ESAPI.validator().getValidInput("HTTP scheme: " + scheme, scheme, "HTTPScheme", 10, false);
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return clean;
    }

    public String getServerName() {
        String name = this.getHttpServletRequest().getServerName();
        String clean = "";
        try {
            clean = ESAPI.validator().getValidInput("HTTP server name: " + name, name, "HTTPServerName", 100, false);
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return clean;
    }

    public int getServerPort() {
        int port = this.getHttpServletRequest().getServerPort();
        if (port < 0 || port > 65535) {
            this.logger.warning(Logger.SECURITY_FAILURE, "HTTP server port out of range: " + port);
            port = 0;
        }
        return port;
    }

    public String getServletPath() {
        String path = this.getHttpServletRequest().getServletPath();
        String clean = "";
        try {
            clean = ESAPI.validator().getValidInput("HTTP servlet path: " + path, path, "HTTPServletPath", 100, false);
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return clean;
    }

    public HttpSession getSession() {
        HttpSession session = this.getHttpServletRequest().getSession();
        if (ESAPI.securityConfiguration().getForceHttpOnlySession() && session.getAttribute("HTTP_ONLY") == null) {
            session.setAttribute("HTTP_ONLY", (Object)"set");
            Cookie cookie = new Cookie(ESAPI.securityConfiguration().getHttpSessionIdName(), session.getId());
            cookie.setPath(this.getHttpServletRequest().getContextPath());
            cookie.setMaxAge(-1);
            HttpServletResponse response = ESAPI.currentResponse();
            if (response != null) {
                ESAPI.currentResponse().addCookie(cookie);
            }
        }
        return session;
    }

    public HttpSession getSession(boolean create) {
        HttpSession session = this.getHttpServletRequest().getSession(create);
        if (session == null) {
            return null;
        }
        if (ESAPI.securityConfiguration().getForceHttpOnlySession() && session.getAttribute("HTTP_ONLY") == null) {
            session.setAttribute("HTTP_ONLY", (Object)"set");
            Cookie cookie = new Cookie(ESAPI.securityConfiguration().getHttpSessionIdName(), session.getId());
            cookie.setMaxAge(-1);
            cookie.setPath(this.getHttpServletRequest().getContextPath());
            HttpServletResponse response = ESAPI.currentResponse();
            if (response != null) {
                ESAPI.currentResponse().addCookie(cookie);
            }
        }
        return session;
    }

    public Principal getUserPrincipal() {
        return ESAPI.authenticator().getCurrentUser();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.getHttpServletRequest().isRequestedSessionIdFromCookie();
    }

    @Deprecated
    public boolean isRequestedSessionIdFromUrl() {
        return this.getHttpServletRequest().isRequestedSessionIdFromUrl();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.getHttpServletRequest().isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdValid() {
        return this.getHttpServletRequest().isRequestedSessionIdValid();
    }

    public boolean isSecure() {
        try {
            ESAPI.httpUtilities().assertSecureChannel();
        }
        catch (AccessControlException e) {
            return false;
        }
        return true;
    }

    public boolean isUserInRole(String role) {
        return ESAPI.authenticator().getCurrentUser().isInRole(role);
    }

    public void removeAttribute(String name) {
        this.getHttpServletRequest().removeAttribute(name);
    }

    public void setAttribute(String name, Object o) {
        this.getHttpServletRequest().setAttribute(name, o);
    }

    public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
        this.getHttpServletRequest().setCharacterEncoding(ESAPI.securityConfiguration().getCharacterEncoding());
    }

    public String getAllowableContentRoot() {
        return this.allowableContentRoot;
    }

    public void setAllowableContentRoot(String allowableContentRoot) {
        this.allowableContentRoot = allowableContentRoot.startsWith("/") ? allowableContentRoot : "/" + allowableContentRoot;
    }
}

