/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.common.binding.security;

import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.security.MetadataCriteria;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.security.SecurityPolicyException;
import org.opensaml.ws.security.provider.BaseTrustEngineRule;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.security.criteria.EntityIDCriteria;
import org.opensaml.xml.security.criteria.UsageCriteria;
import org.opensaml.xml.security.trust.TrustEngine;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSAMLXMLSignatureSecurityPolicyRule
extends BaseTrustEngineRule<Signature> {
    private final Logger log = LoggerFactory.getLogger(BaseSAMLXMLSignatureSecurityPolicyRule.class);

    public BaseSAMLXMLSignatureSecurityPolicyRule(TrustEngine<Signature> engine) {
        super(engine);
    }

    protected CriteriaSet buildCriteriaSet(String entityID, MessageContext messageContext) throws SecurityPolicyException {
        if (!(messageContext instanceof SAMLMessageContext)) {
            this.log.error("Supplied message context was not an instance of SAMLMessageContext, can not build criteria set from SAML metadata parameters");
            throw new SecurityPolicyException("Supplied message context was not an instance of SAMLMessageContext");
        }
        SAMLMessageContext samlContext = (SAMLMessageContext)messageContext;
        CriteriaSet criteriaSet = new CriteriaSet();
        if (!DatatypeHelper.isEmpty((String)entityID)) {
            criteriaSet.add((Object)new EntityIDCriteria(entityID));
        }
        MetadataCriteria mdCriteria = new MetadataCriteria(samlContext.getPeerEntityRole(), samlContext.getInboundSAMLProtocol());
        criteriaSet.add((Object)mdCriteria);
        criteriaSet.add((Object)new UsageCriteria(UsageType.SIGNING));
        return criteriaSet;
    }
}

