/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.security.credential.criteria;

import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.security.credential.criteria.EvaluableCredentialCriteria;
import org.opensaml.xml.security.criteria.UsageCriteria;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluableUsageCredentialCriteria
implements EvaluableCredentialCriteria {
    private final Logger log = LoggerFactory.getLogger(EvaluableUsageCredentialCriteria.class);
    private UsageType usage;

    public EvaluableUsageCredentialCriteria(UsageCriteria criteria) {
        if (criteria == null) {
            throw new NullPointerException("Criteria instance may not be null");
        }
        this.usage = criteria.getUsage();
    }

    public EvaluableUsageCredentialCriteria(UsageType newUsage) {
        if (newUsage == null) {
            throw new IllegalArgumentException("Usage may not be null");
        }
        this.usage = newUsage;
    }

    @Override
    public Boolean evaluate(Credential target) {
        if (target == null) {
            this.log.error("Credential target was null");
            return null;
        }
        UsageType credUsage = target.getUsageType();
        if (credUsage == null) {
            this.log.info("Could not evaluate criteria, credential contained no usage specifier");
            return null;
        }
        Boolean result = this.matchUsage(credUsage, this.usage);
        return result;
    }

    protected boolean matchUsage(UsageType credentialUsage, UsageType criteriaUsage) {
        if (credentialUsage == UsageType.UNSPECIFIED || criteriaUsage == UsageType.UNSPECIFIED) {
            return true;
        }
        return credentialUsage == criteriaUsage;
    }
}

