/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.usermapper.extension;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.automation.scripting.api.AutomationScriptingService;
import org.nuxeo.automation.scripting.internals.AutomationMapper;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.usermapper.extension.AbstractUserMapper;

public class NashornUserMapper
extends AbstractUserMapper {
    protected final String mapperSource;
    protected final String wrapperSource;

    public NashornUserMapper(String mapperScript, String wrapperScript) {
        this.mapperSource = mapperScript;
        this.wrapperSource = wrapperScript;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object wrapNuxeoPrincipal(NuxeoPrincipal principal, Object userObject, Map<String, Serializable> params) {
        if (StringUtils.isEmpty((CharSequence)this.wrapperSource)) {
            return null;
        }
        try (AutomationScriptingService.Session session = ((AutomationScriptingService)Framework.getService(AutomationScriptingService.class)).get((CoreSession)null);){
            Bindings bindings = ((ScriptEngine)session.adapt(ScriptEngine.class)).getBindings(100);
            bindings.put("nuxeoPrincipal", principal);
            bindings.put("userObject", userObject);
            bindings.put("params", params);
            session.run((InputStream)new ByteArrayInputStream(this.wrapperSource.getBytes(StandardCharsets.UTF_8)));
            Object v = bindings.get("userObject");
            return v;
        }
        catch (Exception e) {
            throw new NuxeoException("Error while executing JavaScript mapper", (Throwable)e);
        }
    }

    @Override
    public void init(Map<String, String> params) throws Exception {
    }

    @Override
    public void release() {
    }

    @Override
    protected void resolveAttributes(Object userObject, Map<String, Serializable> searchAttributes, Map<String, Serializable> userAttributes, Map<String, Serializable> profileAttributes) {
        try (AutomationScriptingService.Session session = ((AutomationScriptingService)Framework.getService(AutomationScriptingService.class)).get((CoreSession)null);){
            AutomationMapper mapper = (AutomationMapper)session.adapt(AutomationMapper.class);
            mapper.put("searchAttributes", searchAttributes);
            mapper.put("profileAttributes", profileAttributes);
            mapper.put("userAttributes", userAttributes);
            mapper.put("userObject", userObject);
            session.run((InputStream)new ByteArrayInputStream(this.mapperSource.getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            throw new NuxeoException("Error while executing JavaScript mapper", (Throwable)e);
        }
    }
}

