/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.multi.tenant.dashboard;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.multi.tenant.MultiTenantHelper;
import org.nuxeo.ecm.multi.tenant.dashboard.MultiTenantDefaultDashboardSpaceCreator;
import org.nuxeo.ecm.spaces.api.Space;
import org.nuxeo.ecm.user.center.dashboard.DefaultDashboardSpaceProvider;

public class MultiTenantDefaultDashboardSpaceProvider
extends DefaultDashboardSpaceProvider {
    private static final Log log = LogFactory.getLog(MultiTenantDefaultDashboardSpaceProvider.class);

    protected Space getOrCreateSpace(CoreSession session, Map<String, String> parameters) throws ClientException {
        String tenantId = MultiTenantHelper.getCurrentTenantId(session.getPrincipal());
        if (StringUtils.isBlank((String)tenantId)) {
            return super.getOrCreateSpace(session, parameters);
        }
        String tenantDocumentPath = MultiTenantHelper.getTenantDocumentPath(session, tenantId);
        if (tenantDocumentPath == null) {
            return super.getOrCreateSpace(session, parameters);
        }
        PathRef tenantDashboardManagementRef = new PathRef(tenantDocumentPath, "dashboard-management");
        if (session.exists((DocumentRef)tenantDashboardManagementRef)) {
            PathRef spaceRef = new PathRef(tenantDashboardManagementRef.toString(), "defaultDashboardSpace");
            if (session.exists((DocumentRef)spaceRef)) {
                DocumentModel existingSpace = session.getDocument((DocumentRef)spaceRef);
                return (Space)existingSpace.getAdapter(Space.class);
            }
            DocumentRef defaultDashboardSpaceRef = this.getOrCreateDefaultDashboardSpace(session, parameters, tenantId, tenantDashboardManagementRef.toString());
            DocumentModel defaultDashboardSpace = session.getDocument(defaultDashboardSpaceRef);
            return (Space)defaultDashboardSpace.getAdapter(Space.class);
        }
        DocumentModel tenantDashboardManagement = session.createDocumentModel(tenantDocumentPath, "dashboard-management", "HiddenFolder");
        tenantDashboardManagement.setPropertyValue("dc:title", (Serializable)((Object)"Tenant dashboard management"));
        tenantDashboardManagement.setPropertyValue("dc:description", (Serializable)((Object)"Tenant dashboard management"));
        tenantDashboardManagement = session.createDocument(tenantDashboardManagement);
        DocumentRef defaultDashboardSpaceRef = this.getOrCreateDefaultDashboardSpace(session, parameters, tenantId, tenantDashboardManagement.getPathAsString());
        DocumentModel defaultDashboardSpace = session.getDocument(defaultDashboardSpaceRef);
        return (Space)defaultDashboardSpace.getAdapter(Space.class);
    }

    protected DocumentRef getOrCreateDefaultDashboardSpace(CoreSession session, Map<String, String> parameters, String tenantId, String tenantDashboardManagementPath) throws ClientException {
        MultiTenantDefaultDashboardSpaceCreator defaultDashboardSpaceCreator = new MultiTenantDefaultDashboardSpaceCreator(session, parameters, tenantId, tenantDashboardManagementPath);
        defaultDashboardSpaceCreator.runUnrestricted();
        return defaultDashboardSpaceCreator.defaultDashboardSpaceRef;
    }
}

