/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.multi.tenant;

import java.util.List;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.multi.tenant.MultiTenantPrincipal;
import org.nuxeo.ecm.multi.tenant.cache.SimpleCache;
import org.nuxeo.ecm.platform.computedgroups.UserManagerWithComputedGroups;
import org.nuxeo.ecm.platform.usermanager.NuxeoPrincipalImpl;
import org.nuxeo.runtime.api.Framework;

public class MultiTenantUserManager
extends UserManagerWithComputedGroups {
    protected static final Integer CACHE_MAXIMUM_SIZE = 1000;
    protected final SimpleCache<NuxeoPrincipal> principalCache = new SimpleCache(CACHE_MAXIMUM_SIZE);

    protected NuxeoPrincipal makePrincipal(DocumentModel userEntry, boolean anonymous, List<String> groups) throws ClientException {
        Object nuxeoPrincipal = super.makePrincipal(userEntry, anonymous, groups);
        if (nuxeoPrincipal instanceof NuxeoPrincipalImpl) {
            nuxeoPrincipal = new MultiTenantPrincipal((NuxeoPrincipalImpl)nuxeoPrincipal);
        }
        return nuxeoPrincipal;
    }

    protected boolean useCache() {
        return !Framework.isTestModeSet();
    }

    public NuxeoPrincipal getPrincipal(String username) throws ClientException {
        if (!this.useCache()) {
            return super.getPrincipal(username);
        }
        NuxeoPrincipal principal = this.principalCache.getIfPresent(username);
        if (principal == null && (principal = super.getPrincipal(username)) != null) {
            this.principalCache.put(username, principal);
        }
        return principal;
    }

    protected void notifyUserChanged(String userName) throws ClientException {
        if (this.useCache()) {
            this.principalCache.invalidate(userName);
        }
        super.notifyUserChanged(userName);
    }

    protected void notifyGroupChanged(String groupName) throws ClientException {
        this.invalidateAllPrincipals();
        super.notifyGroupChanged(groupName);
    }

    public void invalidateAllPrincipals() {
        if (this.useCache()) {
            this.principalCache.invalidateAll();
        }
    }
}

