/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.multi.tenant.cache;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SimpleCache<V>
extends LinkedHashMap<String, V> {
    private static final long serialVersionUID = 1L;
    protected final ReentrantReadWriteLock cacheLock = new ReentrantReadWriteLock();
    private final int maxCachedItems;

    public SimpleCache(int maxCachedItems) {
        super(maxCachedItems, 1.0f, true);
        this.maxCachedItems = maxCachedItems;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<String, V> eldest) {
        return this.size() > this.maxCachedItems;
    }

    public V getIfPresent(String key) {
        return this.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        try {
            this.cacheLock.readLock().lock();
            Object v = super.get(key);
            return v;
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(String key, V arg1) {
        try {
            this.cacheLock.writeLock().lock();
            V v = super.put(key, arg1);
            return v;
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(String key) {
        try {
            this.cacheLock.writeLock().lock();
            super.remove(key);
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateAll() {
        try {
            this.cacheLock.writeLock().lock();
            super.clear();
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
    }
}

